/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.util.Iterator;
import org.dom4j.Element;
import org.xmpp.packet.Packet;

public class Presence
extends Packet {
    public Presence() {
        this.element = docFactory.createDocument().addElement("presence");
    }

    public Presence(Type type) {
        this();
        this.setType(type);
    }

    public Presence(Element element) {
        super(element);
    }

    public Presence(Element element, boolean skipValidation) {
        super(element, skipValidation);
    }

    private Presence(Presence presence) {
        Element elementCopy = presence.element.createCopy();
        docFactory.createDocument().add(elementCopy);
        this.element = elementCopy;
        this.toJID = presence.toJID;
        this.fromJID = presence.fromJID;
    }

    public boolean isAvailable() {
        return this.getType() == null;
    }

    public Type getType() {
        String type = this.element.attributeValue("type");
        if (type == null) {
            return null;
        }
        return Type.valueOf(type);
    }

    public void setType(Type type) {
        this.element.addAttribute("type", type == null ? null : type.toString());
    }

    public Show getShow() {
        String show = this.element.elementText("show");
        if (show == null) {
            return null;
        }
        return Show.valueOf(show);
    }

    public void setShow(Show show) {
        Element showElement = this.element.element("show");
        if (show == null) {
            if (showElement != null) {
                this.element.remove(showElement);
            }
            return;
        }
        if (showElement == null) {
            if (!this.isAvailable()) {
                throw new IllegalArgumentException("Cannot set 'show' if 'type' attribute is set.");
            }
            showElement = this.element.addElement("show");
        }
        showElement.setText(show.toString());
    }

    public String getStatus() {
        return this.element.elementText("status");
    }

    public void setStatus(String status) {
        Element statusElement = this.element.element("status");
        if (status == null) {
            if (statusElement != null) {
                this.element.remove(statusElement);
            }
            return;
        }
        if (statusElement == null) {
            statusElement = this.element.addElement("status");
        }
        statusElement.setText(status);
    }

    public int getPriority() {
        String priority = this.element.elementText("priority");
        if (priority == null) {
            return 0;
        }
        try {
            return Integer.parseInt(priority);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setPriority(int priority) {
        if (priority < -128 || priority > 128) {
            throw new IllegalArgumentException("Priority value of " + priority + " is outside the valid range of -128 through 128");
        }
        Element priorityElement = this.element.element("priority");
        if (priorityElement == null) {
            priorityElement = this.element.addElement("priority");
        }
        priorityElement.setText(Integer.toString(priority));
    }

    public Element getChildElement(String name, String namespace) {
        Iterator i = this.element.elementIterator(name);
        while (i.hasNext()) {
            Element element = (Element)i.next();
            if (!element.getNamespaceURI().equals(namespace)) continue;
            return element;
        }
        return null;
    }

    public Element addChildElement(String name, String namespace) {
        return this.element.addElement(name, namespace);
    }

    public Presence createCopy() {
        return new Presence(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Show {
        chat,
        away,
        xa,
        dnd;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        probe,
        error;

    }
}

