/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class FastDateFormat {
    public static final Object FULL = new Integer(0);
    public static final Object LONG = new Integer(1);
    public static final Object MEDIUM = new Integer(2);
    public static final Object SHORT = new Integer(3);
    private static final double LOG_10 = Math.log(10.0);
    private static String cDefaultPattern;
    private static TimeZone cDefaultTimeZone;
    private static Map cTimeZoneDisplayCache;
    private static Map cInstanceCache;
    private static Map cDateInstanceCache;
    private static Map cTimeInstanceCache;
    private static Map cDateTimeInstanceCache;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private final Rule[] mRules;
    private final int mMaxLengthEstimate;

    static {
        cDefaultTimeZone = TimeZone.getDefault();
        cTimeZoneDisplayCache = new HashMap();
        cInstanceCache = new HashMap(7);
        cDateInstanceCache = new HashMap(7);
        cTimeInstanceCache = new HashMap(7);
        cDateTimeInstanceCache = new HashMap(7);
    }

    public static FastDateFormat getInstance() {
        return FastDateFormat.getInstance(FastDateFormat.getDefaultPattern(), null, null, null);
    }

    public static FastDateFormat getInstance(String pattern) throws IllegalArgumentException {
        return FastDateFormat.getInstance(pattern, null, null, null);
    }

    public static FastDateFormat getInstance(String pattern, TimeZone timeZone) throws IllegalArgumentException {
        return FastDateFormat.getInstance(pattern, timeZone, null, null);
    }

    public static FastDateFormat getInstance(String pattern, Locale locale) throws IllegalArgumentException {
        return FastDateFormat.getInstance(pattern, null, locale, null);
    }

    public static FastDateFormat getInstance(String pattern, DateFormatSymbols symbols) throws IllegalArgumentException {
        return FastDateFormat.getInstance(pattern, null, null, symbols);
    }

    public static FastDateFormat getInstance(String pattern, TimeZone timeZone, Locale locale) throws IllegalArgumentException {
        return FastDateFormat.getInstance(pattern, timeZone, locale, null);
    }

    public static synchronized FastDateFormat getInstance(String pattern, TimeZone timeZone, Locale locale, DateFormatSymbols symbols) throws IllegalArgumentException {
        FastDateFormat format;
        Object key = pattern;
        if (timeZone != null) {
            key = new Pair(key, timeZone);
        }
        if (locale != null) {
            key = new Pair(key, locale);
        }
        if (symbols != null) {
            key = new Pair(key, symbols);
        }
        if ((format = (FastDateFormat)cInstanceCache.get(key)) == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (symbols == null) {
                symbols = new DateFormatSymbols(locale);
            }
            format = new FastDateFormat(pattern, timeZone, locale, symbols);
            cInstanceCache.put(key, format);
        }
        return format;
    }

    public static synchronized FastDateFormat getDateInstance(Object style, TimeZone timeZone, Locale locale) throws IllegalArgumentException {
        FastDateFormat format;
        Object key = style;
        if (timeZone != null) {
            key = new Pair(key, timeZone);
        }
        if (locale == null) {
            key = new Pair(key, locale);
        }
        if ((format = (FastDateFormat)cDateInstanceCache.get(key)) == null) {
            int ds;
            try {
                ds = (Integer)style;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal date style: " + style);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                String pattern = ((SimpleDateFormat)DateFormat.getDateInstance(ds, locale)).toPattern();
                format = FastDateFormat.getInstance(pattern, timeZone, locale);
                cDateInstanceCache.put(key, format);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("No date pattern for locale: " + locale);
            }
        }
        return format;
    }

    public static synchronized FastDateFormat getTimeInstance(Object style, TimeZone timeZone, Locale locale) throws IllegalArgumentException {
        FastDateFormat format;
        Object key = style;
        if (timeZone != null) {
            key = new Pair(key, timeZone);
        }
        if (locale != null) {
            key = new Pair(key, locale);
        }
        if ((format = (FastDateFormat)cTimeInstanceCache.get(key)) == null) {
            int ts;
            try {
                ts = (Integer)style;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal time style: " + style);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                String pattern = ((SimpleDateFormat)DateFormat.getTimeInstance(ts, locale)).toPattern();
                format = FastDateFormat.getInstance(pattern, timeZone, locale);
                cTimeInstanceCache.put(key, format);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("No date pattern for locale: " + locale);
            }
        }
        return format;
    }

    public static synchronized FastDateFormat getDateTimeInstance(Object dateStyle, Object timeStyle, TimeZone timeZone, Locale locale) throws IllegalArgumentException {
        FastDateFormat format;
        Pair key = new Pair(dateStyle, timeStyle);
        if (timeZone != null) {
            key = new Pair(key, timeZone);
        }
        if (locale != null) {
            key = new Pair(key, locale);
        }
        if ((format = (FastDateFormat)cDateTimeInstanceCache.get(key)) == null) {
            int ts;
            int ds;
            try {
                ds = (Integer)dateStyle;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal date style: " + dateStyle);
            }
            try {
                ts = (Integer)timeStyle;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal time style: " + timeStyle);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                String pattern = ((SimpleDateFormat)DateFormat.getDateTimeInstance(ds, ts, locale)).toPattern();
                format = FastDateFormat.getInstance(pattern, timeZone, locale);
                cDateTimeInstanceCache.put(key, format);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale);
            }
        }
        return format;
    }

    static synchronized String getTimeZoneDisplay(TimeZone tz, boolean daylight, int style, Locale locale) {
        TimeZoneDisplayKey key = new TimeZoneDisplayKey(tz, daylight, style, locale);
        String value = (String)cTimeZoneDisplayCache.get(key);
        if (value == null) {
            value = tz.getDisplayName(daylight, style, locale);
            cTimeZoneDisplayCache.put(key, value);
        }
        return value;
    }

    private static synchronized String getDefaultPattern() {
        if (cDefaultPattern == null) {
            cDefaultPattern = new SimpleDateFormat().toPattern();
        }
        return cDefaultPattern;
    }

    private static List parse(String pattern, TimeZone timeZone, Locale locale, DateFormatSymbols symbols) {
        ArrayList<NumberRule> rules = new ArrayList<NumberRule>();
        String[] ERAs = symbols.getEras();
        String[] months = symbols.getMonths();
        String[] shortMonths = symbols.getShortMonths();
        String[] weekdays = symbols.getWeekdays();
        String[] shortWeekdays = symbols.getShortWeekdays();
        String[] AmPmStrings = symbols.getAmPmStrings();
        int length = pattern.length();
        int[] indexRef = new int[1];
        int i = 0;
        while (i < length) {
            Rule rule;
            indexRef[0] = i;
            String token = FastDateFormat.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            switch (c) {
                case 'G': {
                    rule = new TextField(0, ERAs);
                    break;
                }
                case 'y': {
                    if (tokenLen >= 4) {
                        rule = new UnpaddedNumberField(1);
                        break;
                    }
                    rule = new TwoDigitYearField();
                    break;
                }
                case 'M': {
                    if (tokenLen >= 4) {
                        rule = new TextField(2, months);
                        break;
                    }
                    if (tokenLen == 3) {
                        rule = new TextField(2, shortMonths);
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = new TwoDigitMonthField();
                        break;
                    }
                    rule = new UnpaddedMonthField();
                    break;
                }
                case 'd': {
                    rule = FastDateFormat.selectNumberRule(5, tokenLen);
                    break;
                }
                case 'h': {
                    rule = new TwelveHourField(FastDateFormat.selectNumberRule(10, tokenLen));
                    break;
                }
                case 'H': {
                    rule = FastDateFormat.selectNumberRule(11, tokenLen);
                    break;
                }
                case 'm': {
                    rule = FastDateFormat.selectNumberRule(12, tokenLen);
                    break;
                }
                case 's': {
                    rule = FastDateFormat.selectNumberRule(13, tokenLen);
                    break;
                }
                case 'S': {
                    rule = FastDateFormat.selectNumberRule(14, tokenLen);
                    break;
                }
                case 'E': {
                    rule = new TextField(7, tokenLen < 4 ? shortWeekdays : weekdays);
                    break;
                }
                case 'D': {
                    rule = FastDateFormat.selectNumberRule(6, tokenLen);
                    break;
                }
                case 'F': {
                    rule = FastDateFormat.selectNumberRule(8, tokenLen);
                    break;
                }
                case 'w': {
                    rule = FastDateFormat.selectNumberRule(3, tokenLen);
                    break;
                }
                case 'W': {
                    rule = FastDateFormat.selectNumberRule(4, tokenLen);
                    break;
                }
                case 'a': {
                    rule = new TextField(9, AmPmStrings);
                    break;
                }
                case 'k': {
                    rule = new TwentyFourHourField(FastDateFormat.selectNumberRule(11, tokenLen));
                    break;
                }
                case 'K': {
                    rule = FastDateFormat.selectNumberRule(10, tokenLen);
                    break;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        rule = new TimeZoneRule(timeZone, locale, 1);
                        break;
                    }
                    rule = new TimeZoneRule(timeZone, locale, 0);
                    break;
                }
                case '\'': {
                    String sub = token.substring(1);
                    if (sub.length() == 1) {
                        rule = new CharacterLiteral(sub.charAt(0));
                        break;
                    }
                    rule = new StringLiteral(new String(sub));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + token);
                }
            }
            rules.add((NumberRule)rule);
            ++i;
        }
        return rules;
    }

    private static String parseToken(String pattern, int[] indexRef) {
        StringBuffer buf = new StringBuffer();
        int i = indexRef[0];
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            buf.append(c);
            while (i + 1 < length) {
                char peek = pattern.charAt(i + 1);
                if (peek == c) {
                    buf.append(c);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            while (i < length) {
                c = pattern.charAt(i);
                if (c == '\'') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        buf.append(c);
                    } else {
                        inLiteral = !inLiteral;
                    }
                } else {
                    if (!inLiteral && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) break;
                    buf.append(c);
                }
                ++i;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }

    private static NumberRule selectNumberRule(int field, int padding) {
        switch (padding) {
            case 1: {
                return new UnpaddedNumberField(field);
            }
            case 2: {
                return new TwoDigitNumberField(field);
            }
        }
        return new PaddedNumberField(field, padding);
    }

    private FastDateFormat() {
        this(FastDateFormat.getDefaultPattern(), null, null, null);
    }

    private FastDateFormat(String pattern) throws IllegalArgumentException {
        this(pattern, null, null, null);
    }

    private FastDateFormat(String pattern, TimeZone timeZone) throws IllegalArgumentException {
        this(pattern, timeZone, null, null);
    }

    private FastDateFormat(String pattern, Locale locale) throws IllegalArgumentException {
        this(pattern, null, locale, null);
    }

    private FastDateFormat(String pattern, DateFormatSymbols symbols) throws IllegalArgumentException {
        this(pattern, null, null, symbols);
    }

    private FastDateFormat(String pattern, TimeZone timeZone, Locale locale) throws IllegalArgumentException {
        this(pattern, timeZone, locale, null);
    }

    private FastDateFormat(String pattern, TimeZone timeZone, Locale locale, DateFormatSymbols symbols) throws IllegalArgumentException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.mPattern = pattern;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        if (symbols == null) {
            symbols = new DateFormatSymbols(locale);
        }
        List rulesList = FastDateFormat.parse(pattern, timeZone, locale, symbols);
        this.mRules = rulesList.toArray(new Rule[rulesList.size()]);
        int len = 0;
        int i = this.mRules.length;
        while (--i >= 0) {
            len += this.mRules[i].estimateLength();
        }
        this.mMaxLengthEstimate = len;
    }

    public String format(Date date) {
        GregorianCalendar c = new GregorianCalendar(cDefaultTimeZone);
        c.setTime(date);
        if (this.mTimeZone != null) {
            ((Calendar)c).setTimeZone(this.mTimeZone);
        }
        return this.applyRules(c, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public StringBuffer format(Date date, StringBuffer buf) {
        GregorianCalendar c = new GregorianCalendar(cDefaultTimeZone);
        c.setTime(date);
        if (this.mTimeZone != null) {
            ((Calendar)c).setTimeZone(this.mTimeZone);
        }
        return this.applyRules(c, buf);
    }

    public StringBuffer format(Calendar calendar, StringBuffer buf) {
        if (this.mTimeZone != null) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return this.applyRules(calendar, buf);
    }

    private StringBuffer applyRules(Calendar calendar, StringBuffer buf) {
        Rule[] rules = this.mRules;
        int len = this.mRules.length;
        int i = 0;
        while (i < len) {
            rules[i].appendTo(buf, calendar);
            ++i;
        }
        return buf;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    private static class CharacterLiteral
    implements Rule {
        private final char mValue;

        CharacterLiteral(char value) {
            this.mValue = value;
        }

        public int estimateLength() {
            return 1;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            buffer.append(this.mValue);
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(StringBuffer var1, int var2);
    }

    private static class PaddedNumberField
    implements NumberRule {
        private final int mField;
        private final int mSize;

        PaddedNumberField(int field, int size) {
            if (size < 3) {
                throw new IllegalArgumentException();
            }
            this.mField = field;
            this.mSize = size;
        }

        public int estimateLength() {
            return 4;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            this.appendTo(buffer, calendar.get(this.mField));
        }

        public final void appendTo(StringBuffer buffer, int value) {
            if (value < 100) {
                int i = this.mSize;
                while (--i >= 2) {
                    buffer.append('0');
                }
                buffer.append((char)(value / 10 + 48));
                buffer.append((char)(value % 10 + 48));
            } else {
                int digits = value < 1000 ? 3 : (int)(Math.log(value) / LOG_10) + 1;
                int i = this.mSize;
                while (--i >= digits) {
                    buffer.append('0');
                }
                buffer.append(Integer.toString(value));
            }
        }
    }

    private static class Pair
    implements Comparable,
    Serializable {
        private final Object mObj1;
        private final Object mObj2;

        public Pair(Object obj1, Object obj2) {
            this.mObj1 = obj1;
            this.mObj2 = obj2;
        }

        public int compareTo(Object obj) {
            if (this == obj) {
                return 0;
            }
            Pair other = (Pair)obj;
            Object a = this.mObj1;
            Object b = other.mObj1;
            if (a == null) {
                if (b != null) {
                    return 1;
                }
            } else {
                if (b == null) {
                    return -1;
                }
                int result = ((Comparable)a).compareTo(b);
                if (result != 0) {
                    return result;
                }
            }
            a = this.mObj2;
            b = other.mObj2;
            if (a == null) {
                if (b != null) {
                    return 1;
                }
                return 0;
            }
            if (b == null) {
                return -1;
            }
            return ((Comparable)a).compareTo(b);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Pair)) {
                return false;
            }
            Pair key = (Pair)obj;
            return (this.mObj1 == null ? key.mObj1 == null : this.mObj1.equals(key.mObj1)) && (this.mObj2 == null ? key.mObj2 == null : this.mObj2.equals(key.mObj2));
        }

        public int hashCode() {
            return (this.mObj1 == null ? 0 : this.mObj1.hashCode()) + (this.mObj2 == null ? 0 : this.mObj2.hashCode());
        }

        public String toString() {
            return "[" + this.mObj1 + ':' + this.mObj2 + ']';
        }
    }

    private static interface Rule {
        public int estimateLength();

        public void appendTo(StringBuffer var1, Calendar var2);
    }

    private static class StringLiteral
    implements Rule {
        private final String mValue;

        StringLiteral(String value) {
            this.mValue = value;
        }

        public int estimateLength() {
            return this.mValue.length();
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            buffer.append(this.mValue);
        }
    }

    private static class TextField
    implements Rule {
        private final int mField;
        private final String[] mValues;

        TextField(int field, String[] values) {
            this.mField = field;
            this.mValues = values;
        }

        public int estimateLength() {
            int max = 0;
            int i = this.mValues.length;
            while (--i >= 0) {
                int len = this.mValues[i].length();
                if (len <= max) continue;
                max = len;
            }
            return max;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            buffer.append(this.mValues[calendar.get(this.mField)]);
        }
    }

    private static class TimeZoneDisplayKey {
        private final TimeZone mTimeZone;
        private final int mStyle;
        private final Locale mLocale;

        TimeZoneDisplayKey(TimeZone timeZone, boolean daylight, int style, Locale locale) {
            this.mTimeZone = timeZone;
            if (daylight) {
                style |= Integer.MIN_VALUE;
            }
            this.mStyle = style;
            this.mLocale = locale;
        }

        public int hashCode() {
            return this.mStyle * 31 + this.mLocale.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TimeZoneDisplayKey) {
                TimeZoneDisplayKey other = (TimeZoneDisplayKey)obj;
                return this.mTimeZone.equals(other.mTimeZone) && this.mStyle == other.mStyle && this.mLocale.equals(other.mLocale);
            }
            return false;
        }
    }

    private static class TimeZoneRule
    implements Rule {
        private final TimeZone mTimeZone;
        private final Locale mLocale;
        private final int mStyle;
        private final String mStandard;
        private final String mDaylight;

        TimeZoneRule(TimeZone timeZone, Locale locale, int style) {
            this.mTimeZone = timeZone;
            this.mLocale = locale;
            this.mStyle = style;
            if (timeZone != null) {
                this.mStandard = FastDateFormat.getTimeZoneDisplay(timeZone, false, style, locale);
                this.mDaylight = FastDateFormat.getTimeZoneDisplay(timeZone, true, style, locale);
            } else {
                this.mStandard = null;
                this.mDaylight = null;
            }
        }

        public int estimateLength() {
            if (this.mTimeZone != null) {
                return Math.max(this.mStandard.length(), this.mDaylight.length());
            }
            if (this.mStyle == 0) {
                return 4;
            }
            return 40;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            TimeZone timeZone = this.mTimeZone;
            if (timeZone != null) {
                if (timeZone.useDaylightTime() && calendar.get(16) != 0) {
                    buffer.append(this.mDaylight);
                } else {
                    buffer.append(this.mStandard);
                }
            } else {
                timeZone = calendar.getTimeZone();
                if (timeZone.useDaylightTime() && calendar.get(16) != 0) {
                    buffer.append(FastDateFormat.getTimeZoneDisplay(timeZone, true, this.mStyle, this.mLocale));
                } else {
                    buffer.append(FastDateFormat.getTimeZoneDisplay(timeZone, false, this.mStyle, this.mLocale));
                }
            }
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwelveHourField(NumberRule rule) {
            this.mRule = rule;
        }

        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            int value = calendar.get(10);
            if (value == 0) {
                value = calendar.getLeastMaximum(10) + 1;
            }
            this.mRule.appendTo(buffer, value);
        }

        public void appendTo(StringBuffer buffer, int value) {
            this.mRule.appendTo(buffer, value);
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwentyFourHourField(NumberRule rule) {
            this.mRule = rule;
        }

        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            int value = calendar.get(11);
            if (value == 0) {
                value = calendar.getMaximum(11) + 1;
            }
            this.mRule.appendTo(buffer, value);
        }

        public void appendTo(StringBuffer buffer, int value) {
            this.mRule.appendTo(buffer, value);
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        TwoDigitMonthField() {
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            this.appendTo(buffer, calendar.get(2) + 1);
        }

        public final void appendTo(StringBuffer buffer, int value) {
            buffer.append((char)(value / 10 + 48));
            buffer.append((char)(value % 10 + 48));
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int mField;

        TwoDigitNumberField(int field) {
            this.mField = field;
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            this.appendTo(buffer, calendar.get(this.mField));
        }

        public final void appendTo(StringBuffer buffer, int value) {
            if (value < 100) {
                buffer.append((char)(value / 10 + 48));
                buffer.append((char)(value % 10 + 48));
            } else {
                buffer.append(Integer.toString(value));
            }
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        TwoDigitYearField() {
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            this.appendTo(buffer, calendar.get(1) % 100);
        }

        public final void appendTo(StringBuffer buffer, int value) {
            buffer.append((char)(value / 10 + 48));
            buffer.append((char)(value % 10 + 48));
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        UnpaddedMonthField() {
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            this.appendTo(buffer, calendar.get(2) + 1);
        }

        public final void appendTo(StringBuffer buffer, int value) {
            if (value < 10) {
                buffer.append((char)(value + 48));
            } else {
                buffer.append((char)(value / 10 + 48));
                buffer.append((char)(value % 10 + 48));
            }
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int mField;

        UnpaddedNumberField(int field) {
            this.mField = field;
        }

        public int estimateLength() {
            return 4;
        }

        public void appendTo(StringBuffer buffer, Calendar calendar) {
            this.appendTo(buffer, calendar.get(this.mField));
        }

        public final void appendTo(StringBuffer buffer, int value) {
            if (value < 10) {
                buffer.append((char)(value + 48));
            } else if (value < 100) {
                buffer.append((char)(value / 10 + 48));
                buffer.append((char)(value % 10 + 48));
            } else {
                buffer.append(Integer.toString(value));
            }
        }
    }
}

