/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import java.util.StringTokenizer;
import javax.sip.address.Hop;

public class HopImpl
implements Hop {
    protected String host;
    protected int port;
    protected String transport;
    protected boolean explicitRoute;
    protected boolean defaultRoute;
    protected boolean uriRoute;

    public String toString() {
        return this.host + ":" + this.port + "/" + this.transport;
    }

    public HopImpl(String hostName, int portNumber, String trans) {
        this.host = hostName;
        if (this.host.indexOf(":") >= 0 && this.host.indexOf("[") < 0) {
            this.host = "[" + this.host + "]";
        }
        this.port = portNumber;
        this.transport = trans;
    }

    public HopImpl(String hop) throws IllegalArgumentException {
        if (hop == null) {
            throw new IllegalArgumentException("Null arg!");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(hop + "/");
        String hostPort = stringTokenizer.nextToken("/").trim();
        this.transport = stringTokenizer.nextToken().trim();
        if (this.transport == null) {
            this.transport = "UDP";
        } else if (this.transport == "") {
            this.transport = "UDP";
        }
        if (this.transport.compareToIgnoreCase("UDP") != 0 && this.transport.compareToIgnoreCase("TLS") != 0 && this.transport.compareToIgnoreCase("TCP") != 0) {
            System.out.println("Bad transport string " + this.transport);
            throw new IllegalArgumentException(hop);
        }
        String portString = null;
        if (hostPort.charAt(0) == '[') {
            int rightSqBrackIndex = hostPort.indexOf(93);
            if (rightSqBrackIndex == -1) {
                throw new IllegalArgumentException("Bad IPv6 reference spec");
            }
            this.host = hostPort.substring(0, rightSqBrackIndex + 1);
            int portColon = hostPort.indexOf(58, rightSqBrackIndex);
            if (portColon != -1) {
                try {
                    portString = hostPort.substring(portColon + 1).trim();
                }
                catch (IndexOutOfBoundsException exc) {}
            }
        } else if (hostPort.indexOf(58) != hostPort.lastIndexOf(":")) {
            this.host = '[' + hostPort + ']';
        } else {
            int portColon = hostPort.indexOf(58);
            if (portColon == -1) {
                this.host = hostPort;
            } else {
                this.host = hostPort.substring(0, portColon).trim();
                try {
                    portString = hostPort.substring(portColon + 1).trim();
                }
                catch (IndexOutOfBoundsException exc) {
                    // empty catch block
                }
            }
        }
        if (this.host == null || this.host.equals("")) {
            throw new IllegalArgumentException("no host!");
        }
        if (portString == null || portString.equals("")) {
            this.port = 5060;
        } else {
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Bad port spec");
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isExplicitRoute() {
        return this.explicitRoute;
    }

    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public boolean isURIRoute() {
        return this.uriRoute;
    }

    public void setURIRouteFlag() {
        this.uriRoute = true;
    }

    public void setDefaultRouteFlag() {
        this.defaultRoute = true;
    }

    public void setExplicitRouteFlag() {
        this.explicitRoute = true;
    }
}

