/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.prophecy.config;

import com.voxeo.prophecy.config.ConfigFileException;
import com.voxeo.prophecy.config.IPropertyBoundConfigFile;
import com.voxeo.utils.Closer;
import com.voxeo.utils.Strings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigXml
implements IPropertyBoundConfigFile {
    private final String encoding;
    private byte[] content;
    private Map<String, String> properties;

    public ConfigXml(Map<String, String> props, String encoding) {
        this.encoding = encoding;
        this.content = ConfigXml.toBytes(props, encoding);
    }

    public ConfigXml(byte[] content, String encoding) {
        this.content = content;
        this.encoding = encoding;
    }

    @Override
    public void applyChanges(Map<String, String> props) {
        try {
            Document doc = ConfigXml.parseDocument(this.content, this.encoding);
            ConfigXml.merge(props, doc.getRootElement());
            this.content = ConfigXml.toBytes(doc);
        }
        catch (Exception e) {
            throw new ConfigFileException("Error merging properties", e);
        }
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            try {
                this.properties = ConfigXml.parse(this.content, this.encoding);
            }
            catch (Exception e) {
                throw new ConfigFileException("Error parsing content", e);
            }
        }
        return this.properties;
    }

    private static boolean foundBom(byte[] bytes) {
        return bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
    }

    private static final Document parseDocument(byte[] bytes, String encoding) {
        try {
            byte[] contents = bytes;
            if (ConfigXml.foundBom(bytes)) {
                contents = new byte[bytes.length - 3];
                System.arraycopy(bytes, 3, contents, 0, bytes.length - 3);
            }
            String text = new String(contents, encoding);
            return DocumentHelper.parseText((String)text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing XML", e);
        }
    }

    private static final Map<String, String> parse(byte[] bytes, String encoding) {
        try {
            Document doc = ConfigXml.parseDocument(bytes, encoding);
            Element root = doc.getRootElement();
            HashMap<String, String> r = new HashMap<String, String>();
            Stack<String> categories = new Stack<String>();
            ConfigXml.loadKeyValuePairs(root, categories, r);
            return r;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing XML", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] toBytes(Map<String, String> props, String encoding) {
        byte[] byArray;
        Object writer = null;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            Document doc = DocumentHelper.createDocument();
            doc.setXMLEncoding(encoding);
            Element root = DocumentHelper.createElement((String)"config");
            doc.setRootElement(root);
            ConfigXml.merge(props, root);
            byArray = ConfigXml.toBytes(doc);
        }
        catch (Throwable throwable) {
            Closer.closeAll(writer, bytesOut);
            throw throwable;
        }
        Closer.closeAll(writer, bytesOut);
        return byArray;
    }

    private static void loadKeyValuePairs(Element parent, Stack<String> categories, Map<String, String> map) {
        for (Element element : parent.elements()) {
            String elementName = element.getName();
            categories.push(element.attributeValue("name"));
            if ("item".equalsIgnoreCase(elementName)) {
                String key = Strings.join(categories, ".");
                String value = element.getTextTrim();
                map.put(key, value);
            } else if ("category".equalsIgnoreCase(elementName)) {
                ConfigXml.loadKeyValuePairs(element, categories, map);
            }
            categories.pop();
        }
    }

    private static void merge(Map<String, String> props, Element root) {
        for (String key : props.keySet()) {
            String value = props.get(key);
            String[] categories = key.split("\\.");
            Element parent = root;
            Element element = null;
            for (int i = 0; i < categories.length; ++i) {
                element = null;
                String category = categories[i];
                boolean expectingItem = i == categories.length - 1;
                for (Element child : parent.elements()) {
                    String name = child.attributeValue("name");
                    if (!category.equals(name)) continue;
                    element = child;
                    break;
                }
                if (element != null) {
                    if (expectingItem && !"item".equalsIgnoreCase(element.getName())) {
                        throw new IllegalStateException("Trying to place an item where category of same name already exists!");
                    }
                    if (!expectingItem && !"category".equalsIgnoreCase(element.getName())) {
                        throw new IllegalStateException("Trying to place a category where item of same name already exists!");
                    }
                } else {
                    element = DocumentHelper.createElement((String)(expectingItem ? "item" : "category"));
                    element.addAttribute("name", category);
                    parent.add(element);
                }
                parent = element;
            }
            element.setText(Strings.isNull(value, new String[0]));
        }
    }

    private static byte[] toBytes(Document doc) {
        byte[] byArray;
        XMLWriter writer = null;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            writer = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)bytesOut, doc.getXMLEncoding()), OutputFormat.createPrettyPrint());
            writer.write(doc);
            writer.flush();
            byArray = bytesOut.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new ConfigFileException("Error serializing XML", e);
            }
            catch (Throwable throwable) {
                Closer.closeAll(writer, bytesOut);
                throw throwable;
            }
        }
        Closer.closeAll(writer, bytesOut);
        return byArray;
    }

    @Override
    public boolean fromBooleanValueString(String value) {
        return Strings.isEmpty(value, "0").equals("1");
    }

    @Override
    public String toBooleanValueString(boolean value) {
        return value ? "1" : "0";
    }
}

