/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.IParser;
import net.sf.jqql.packets.PacketHistory;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import net.sf.jqql.packets.in._05.RequestAgentReplyPacket;
import net.sf.jqql.packets.in._05.RequestBeginReplyPacket;
import net.sf.jqql.packets.in._05.RequestFaceReplyPacket;
import net.sf.jqql.packets.in._05.TransferReplyPacket;
import net.sf.jqql.packets.in._05.Unknown05InPacket;
import net.sf.jqql.packets.out._05.RequestAgentPacket;
import net.sf.jqql.packets.out._05.RequestBeginPacket;
import net.sf.jqql.packets.out._05.TransferPacket;
import net.sf.jqql.packets.out._05.Unknown05OutPacket;

public class _05FamilyParser
implements IParser {
    private int offset;
    private int length;

    public boolean isDuplicate(_08InPacket _08InPacket2) {
        return false;
    }

    public boolean accept(ByteBuffer byteBuffer) {
        this.offset = byteBuffer.position();
        int n = byteBuffer.limit() - this.offset;
        if (n <= 0) {
            return false;
        }
        if (byteBuffer.get(this.offset) != 5) {
            return false;
        }
        if (n < 5) {
            return false;
        }
        this.length = byteBuffer.getChar(this.offset + 3);
        if (this.length > n) {
            return false;
        }
        return byteBuffer.get(this.offset + this.length - 1) == 3;
    }

    public int getLength(ByteBuffer byteBuffer) {
        return this.length;
    }

    public _08InPacket parseIncoming(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        try {
            switch (byteBuffer.getChar(this.offset + 5)) {
                case '!': {
                    return new RequestAgentReplyPacket(byteBuffer, n, qQUser);
                }
                case '\"': {
                    return new RequestFaceReplyPacket(byteBuffer, n, qQUser);
                }
                case '&': {
                    return new RequestBeginReplyPacket(byteBuffer, n, qQUser);
                }
                case '#': {
                    return new TransferReplyPacket(byteBuffer, n, qQUser);
                }
            }
            return new Unknown05InPacket(byteBuffer, n, qQUser);
        }
        catch (PacketParseException packetParseException) {
            byteBuffer.position(this.offset);
            return new Unknown05InPacket(byteBuffer, n, qQUser);
        }
    }

    public _08OutPacket parseOutcoming(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        try {
            switch (byteBuffer.getChar(this.offset + 5)) {
                case '!': {
                    return new RequestAgentPacket(byteBuffer, n, qQUser);
                }
                case '&': {
                    return new RequestBeginPacket(byteBuffer, n, qQUser);
                }
                case '#': {
                    return new TransferPacket(byteBuffer, n, qQUser);
                }
            }
            return new Unknown05OutPacket(byteBuffer, n, qQUser);
        }
        catch (PacketParseException packetParseException) {
            byteBuffer.position(this.offset);
            return new Unknown05OutPacket(byteBuffer, n, qQUser);
        }
    }

    public boolean isDuplicatedNeedReply(_08InPacket _08InPacket2) {
        return false;
    }

    public int relocate(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        if (byteBuffer.remaining() < 5) {
            return n;
        }
        char c = byteBuffer.getChar(n + 3);
        if (c == '\u0000' || n + c > byteBuffer.limit()) {
            return n;
        }
        return n + c;
    }

    public PacketHistory getHistory() {
        return null;
    }
}

