/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;

public class MUCInitialPresence
implements PacketExtension {
    private String password;
    private History history;

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/muc";
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        if (this.getPassword() != null) {
            buf.append("<password>").append(this.getPassword()).append("</password>");
        }
        if (this.getHistory() != null) {
            buf.append(this.getHistory().toXML());
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    public History getHistory() {
        return this.history;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static class History {
        private int maxChars = -1;
        private int maxStanzas = -1;
        private int seconds = -1;
        private Date since;

        public int getMaxChars() {
            return this.maxChars;
        }

        public int getMaxStanzas() {
            return this.maxStanzas;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public Date getSince() {
            return this.since;
        }

        public void setMaxChars(int maxChars) {
            this.maxChars = maxChars;
        }

        public void setMaxStanzas(int maxStanzas) {
            this.maxStanzas = maxStanzas;
        }

        public void setSeconds(int seconds) {
            this.seconds = seconds;
        }

        public void setSince(Date since) {
            this.since = since;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<history");
            if (this.getMaxChars() != -1) {
                buf.append(" maxchars=\"").append(this.getMaxChars()).append("\"");
            }
            if (this.getMaxStanzas() != -1) {
                buf.append(" maxstanzas=\"").append(this.getMaxStanzas()).append("\"");
            }
            if (this.getSeconds() != -1) {
                buf.append(" seconds=\"").append(this.getSeconds()).append("\"");
            }
            if (this.getSince() != null) {
                SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                buf.append(" since=\"").append(utcFormat.format(this.getSince())).append("\"");
            }
            buf.append("/>");
            return buf.toString();
        }
    }
}

