/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.multimap.impl.MultiMapPortableHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PortableEntrySetResponse
implements Portable {
    Set<Map.Entry> entrySet;

    public PortableEntrySetResponse() {
    }

    public PortableEntrySetResponse(Set<Map.Entry> entrySet) {
        this.entrySet = entrySet;
    }

    public Set<Map.Entry> getEntrySet() {
        return this.entrySet;
    }

    @Override
    public int getFactoryId() {
        return MultiMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("s", this.entrySet.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Map.Entry entry : this.entrySet) {
            Data key = (Data)entry.getKey();
            Data value = (Data)entry.getValue();
            out.writeData(key);
            out.writeData(value);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.entrySet = new HashSet<Map.Entry>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            this.entrySet.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
        }
    }
}

