/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TypeSelector
extends BaseExtendSelector {
    public static final String TYPE_KEY = "type";
    private String type;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{typeselector type: ");
        stringBuffer.append(this.type);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setType(FileType fileType) {
        this.type = fileType.getValue();
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                String string = parameterArray[n].getName();
                if (TYPE_KEY.equalsIgnoreCase(string)) {
                    FileType fileType = new FileType();
                    fileType.setValue(parameterArray[n].getValue());
                    this.setType(fileType);
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.type == null) {
            this.setError("The type attribute is required");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        if (file2.isDirectory()) {
            return this.type.equals("dir");
        }
        return this.type.equals("file");
    }

    private final /* synthetic */ void this() {
        this.type = null;
    }

    public TypeSelector() {
        this.this();
    }

    public static class FileType
    extends EnumeratedAttribute {
        public static final String FILE = "file";
        public static final String DIR = "dir";

        public String[] getValues() {
            return new String[]{FILE, DIR};
        }
    }
}

