/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.openymsg.network.PropertyConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util
implements PropertyConstants {
    private static final String[] ENTITIES_STR = new String[]{"apos", "quot", "amp", "lt", "gt", "nbsp", "curren", "cent", "pound", "yen", "copy"};
    private static final char[] ENTITIES_CHR = new char[]{'\'', '\"', '&', '<', '>', ' ', '\u00a4', '\u00a2', '\u00a3', '\u00a5', '\u00a9'};

    public static int loginTimeout(int n) {
        int n2 = Integer.parseInt(System.getProperty("openymsg.network.loginTimeout", "" + n)) * 1000;
        if (n2 <= 0) {
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    public static String directHost() {
        return System.getProperty("openymsg.network.directHost", "scs.msg.yahoo.com");
    }

    static int[] directPorts() {
        String string = System.getProperty("openymsg.network.directPorts");
        if (string == null) {
            return DIRECT_PORTS_DEFAULT;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public static int directPort() {
        return Util.directPorts()[0];
    }

    public static String httpHost() {
        return System.getProperty("openymsg.network.httpHost", "http.pager.yahoo.com");
    }

    public static String httpProxyAuth() {
        return System.getProperty("openymsg.network.httpProxyAuth");
    }

    public static String fileTransferHost() {
        return System.getProperty("openymsg.network.fileTransferHost", "filetransfer.msg.yahoo.com");
    }

    public static String httpProxyHost() {
        String string = System.getProperty("http.proxyHost");
        if (string == null) {
            string = System.getProperty("proxyHost");
        }
        return string;
    }

    public static int httpProxyPort() {
        String string = System.getProperty("http.proxyPort");
        if (string == null) {
            string = System.getProperty("proxyPort");
        }
        if (string == null) {
            string = "8080";
        }
        return Integer.parseInt(string);
    }

    public static void initURLConnection(URLConnection uRLConnection) {
        String string = Util.httpProxyAuth();
        if (string != null) {
            uRLConnection.setRequestProperty("Proxy-Authorization", string);
        }
    }

    public static String _base64(String string, char c, byte[] byArray) {
        int n;
        int n2 = byArray.length - byArray.length % 3;
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[byArray.length];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        for (n = 0; n < n2; n += 3) {
            stringBuffer.append(string.charAt(nArray[n] >> 2));
            stringBuffer.append(string.charAt(nArray[n] << 4 & 0x30 | nArray[n + 1] >> 4));
            stringBuffer.append(string.charAt(nArray[n + 1] << 2 & 0x3C | nArray[n + 2] >> 6));
            stringBuffer.append(string.charAt(nArray[n + 2] & 0x3F));
        }
        n = n2;
        switch (nArray.length - n) {
            case 1: {
                stringBuffer.append(string.charAt(nArray[n] >> 2));
                stringBuffer.append(string.charAt(nArray[n] << 4 & 0x30));
                stringBuffer.append(c).append(c);
                break;
            }
            case 2: {
                stringBuffer.append(string.charAt(nArray[n] >> 2));
                stringBuffer.append(string.charAt(nArray[n] << 4 & 0x30 | nArray[n + 1] >> 4));
                stringBuffer.append(string.charAt(nArray[n + 1] << 2 & 0x3C));
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public static String base64(byte[] byArray) {
        return Util._base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", '=', byArray);
    }

    public static final boolean isUtf8(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String entityDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("&");
        while (n >= 0) {
            int n2 = string.indexOf(";");
            if (n2 >= 0 && n2 > n + 1) {
                stringBuffer.append(string.substring(0, n));
                String string2 = string.substring(n + 1, n2).toLowerCase();
                int n3 = 0;
                for (n3 = 0; n3 < ENTITIES_STR.length; ++n3) {
                    if (!ENTITIES_STR[n3].equals(string2)) continue;
                    stringBuffer.append(ENTITIES_CHR[n3]);
                    break;
                }
                if (n3 >= ENTITIES_STR.length) {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
                string = string.substring(n2 + 1);
            } else {
                stringBuffer.append(string.substring(0, n + 1));
                string = string.substring(n + 1);
            }
            n = string.indexOf("&");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static int[] yahoo64Decode(String string) {
        if (string.length() % 4 != 0) {
            throw new IllegalArgumentException("Source string incomplete");
        }
        int n = string.length() / 4;
        if (string.endsWith("--")) {
            n -= 2;
        } else if (string.endsWith("-")) {
            --n;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[4];
        int n2 = 0;
        try {
            for (int i = 0; i < string.length(); i += 4) {
                int n3 = 0;
                while (i < nArray2.length) {
                    nArray2[n3] = Util._c2b(string.charAt(i + n3));
                    ++n3;
                }
                nArray[n2 + 0] = (nArray2[0] << 2) + (nArray2[1] >> 4) & 0xFF;
                nArray[n2 + 1] = (nArray2[1] & 0xF) << 4 + (nArray2[2] >> 2) & 0xFF;
                nArray[n2 + 2] = (nArray2[2] & 3) << 6 + nArray2[3] & 0xFF;
                n2 += 3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return nArray;
    }

    private static int _c2b(int n) {
        if (n >= 65 && n <= 90) {
            return n - 65;
        }
        if (n >= 97 && n <= 122) {
            return n - 97 + 26;
        }
        if (n >= 48 && n <= 57) {
            return n - 48 + 52;
        }
        if (n == 46) {
            return 62;
        }
        if (n == 95) {
            return 63;
        }
        return 0;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        if (n < byArray.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    public static String getValue(Hashtable<String, String> hashtable, String string, String string2) {
        if (hashtable.containsKey(string)) {
            return hashtable.get(string);
        }
        return string2;
    }
}

