/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.PacketExtension;

public abstract class AbstractPacketExtension
implements PacketExtension {
    private String namespace;
    private final String elementName;
    protected final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private String textContent;
    private final List<PacketExtension> childExtensions = new ArrayList<PacketExtension>();

    protected AbstractPacketExtension(String namespace, String elementName) {
        this.namespace = namespace;
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("<").append(this.getElementName()).append(" ");
        String namespace = this.getNamespace();
        if (namespace != null) {
            bldr.append("xmlns='").append(namespace).append("'");
        }
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            bldr.append(" ").append(entry.getKey()).append("='").append(entry.getValue()).append("'");
        }
        List<? extends PacketExtension> childElements = this.getChildExtensions();
        String text = this.getText();
        if (childElements == null) {
            if (text == null || text.length() == 0) {
                bldr.append("/>");
                return bldr.toString();
            }
            bldr.append('>');
        } else {
            List<? extends PacketExtension> list = childElements;
            synchronized (list) {
                if (childElements.isEmpty() && (text == null || text.length() == 0)) {
                    bldr.append("/>");
                    return bldr.toString();
                }
                bldr.append(">");
                for (PacketExtension packetExtension : childElements) {
                    bldr.append(packetExtension.toXML());
                }
            }
        }
        if (text != null && text.trim().length() > 0) {
            bldr.append(text);
        }
        bldr.append("</").append(this.getElementName()).append(">");
        return bldr.toString();
    }

    public List<? extends PacketExtension> getChildExtensions() {
        return this.childExtensions;
    }

    public void addChildExtension(PacketExtension childExtension) {
        this.childExtensions.add(childExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            if (value != null) {
                this.attributes.put(name, value.toString());
            } else {
                this.attributes.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attribute) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeAsString(String attribute) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            String attributeVal = this.attributes.get(attribute);
            return attributeVal == null ? null : attributeVal.toString();
        }
    }

    public int getAttributeAsInt(String attribute) {
        return this.getAttributeAsInt(attribute, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttributeAsInt(String attribute, int defaultValue) {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            String value = this.getAttributeAsString(attribute);
            return value == null ? defaultValue : Integer.parseInt(value);
        }
    }

    public URI getAttributeAsURI(String attribute) throws IllegalArgumentException {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            String attributeVal = this.getAttributeAsString(attribute);
            if (attributeVal == null) {
                return null;
            }
            try {
                URI uri = new URI(attributeVal);
                return uri;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAttributeNames() {
        Map<String, String> map = this.attributes;
        synchronized (map) {
            return new ArrayList<String>(this.attributes.keySet());
        }
    }

    public void setText(String text) {
        this.textContent = text;
    }

    public String getText() {
        return this.textContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PacketExtension> T getFirstChildOfType(Class<T> type) {
        List<? extends PacketExtension> childExtensions;
        List<? extends PacketExtension> list = childExtensions = this.getChildExtensions();
        synchronized (list) {
            for (PacketExtension packetExtension : childExtensions) {
                if (!type.isInstance(packetExtension)) continue;
                PacketExtension extensionAsType = packetExtension;
                return (T)extensionAsType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PacketExtension> List<T> getChildExtensionsOfType(Class<T> type) {
        List<? extends PacketExtension> childExtensions = this.getChildExtensions();
        ArrayList<PacketExtension> result = new ArrayList<PacketExtension>();
        if (childExtensions == null) {
            return result;
        }
        List<? extends PacketExtension> list = childExtensions;
        synchronized (list) {
            for (PacketExtension packetExtension : childExtensions) {
                if (!type.isInstance(packetExtension)) continue;
                PacketExtension extensionAsType = packetExtension;
                result.add(extensionAsType);
            }
        }
        return result;
    }
}

