/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.pseudotcp.MultiThreadSupportTest;
import org.ice4j.pseudotcp.Option;
import org.ice4j.pseudotcp.PseudoTCPBase;
import org.ice4j.pseudotcp.PseudoTcpNotify;
import org.ice4j.pseudotcp.WriteResult;

public abstract class PseudoTcpTestBase
extends MultiThreadSupportTest
implements PseudoTcpNotify {
    private static final Logger logger = Logger.getLogger(PseudoTCPBase.class.getName());
    private final PseudoTCPBase remoteTcp;
    private final PseudoTCPBase localTcp;
    private int local_mtu_;
    private int remote_mtu_;
    private int delay_;
    private int loss_;
    protected boolean have_connected_;
    protected boolean have_disconnected_;
    private Timer timer = new Timer("Delay timer");
    static final int kConnectTimeoutMs = 5000;
    static final int kMinTransferRate = 1000;
    static final int kBlockSize = 4096;
    private Random random = new Random();
    private Thread localClockThread;
    private final Object localClockLock = new Object();
    private Thread remoteClockThread;
    private final Object remoteClockLock = new Object();
    private boolean runClocks = false;

    public PseudoTcpTestBase() {
        this.remoteTcp = new PseudoTCPBase(this, 1L);
        this.remoteTcp.debugName = "REM";
        this.localTcp = new PseudoTCPBase(this, 1L);
        this.localTcp.debugName = "LOC";
        this.setLocalMtu(65535);
        this.setRemoteMtu(65535);
    }

    public static byte[] createDummyData(int size) {
        byte[] dummy = new byte[size];
        Random r = new Random();
        r.nextBytes(dummy);
        return dummy;
    }

    void setLocalMtu(int mtu) {
        this.localTcp.notifyMTU(mtu);
        this.local_mtu_ = mtu;
    }

    void setRemoteMtu(int mtu) {
        this.remoteTcp.notifyMTU(mtu);
        this.remote_mtu_ = mtu;
    }

    void setDelay(int delay) {
        this.delay_ = delay;
    }

    void setLoss(int percent) {
        this.loss_ = percent;
    }

    void setOptNagling(boolean enable_nagles) {
        this.localTcp.setOption(Option.OPT_NODELAY, enable_nagles ? 0L : 1L);
        this.remoteTcp.setOption(Option.OPT_NODELAY, enable_nagles ? 0L : 1L);
    }

    void setOptAckDelay(int ack_delay) {
        this.localTcp.setOption(Option.OPT_ACKDELAY, ack_delay);
        this.remoteTcp.setOption(Option.OPT_ACKDELAY, ack_delay);
    }

    void setOptSndBuf(int size) {
        this.localTcp.setOption(Option.OPT_SNDBUF, size);
        this.remoteTcp.setOption(Option.OPT_SNDBUF, size);
    }

    void setRemoteOptRcvBuf(int size) {
        this.remoteTcp.setOption(Option.OPT_RCVBUF, size);
    }

    void setLocalOptRcvBuf(int size) {
        this.localTcp.setOption(Option.OPT_RCVBUF, size);
    }

    void disableRemoteWindowScale() {
        this.remoteTcp.disableWindowScale();
    }

    void disableLocalWindowScale() {
        this.localTcp.disableWindowScale();
    }

    void connect() throws IOException {
        this.localTcp.connect();
        this.updateLocalClock();
    }

    void close() {
        this.localTcp.close(false);
        this.updateLocalClock();
    }

    public void onTcpOpen(PseudoTCPBase tcp) {
        if (tcp == this.localTcp) {
            this.have_connected_ = true;
            this.onTcpWriteable(tcp);
        }
    }

    public void onTcpClosed(PseudoTCPBase tcp, IOException exc) {
        assert (exc == null);
        if (tcp == this.remoteTcp) {
            this.have_disconnected_ = true;
        }
    }

    int randomInt() {
        return this.random.nextInt(100);
    }

    int localSend(byte[] data, int len) throws IOException {
        return this.localTcp.send(data, len);
    }

    int localRecv(byte[] buffer, int len) throws IOException {
        return this.localTcp.recv(buffer, len);
    }

    int remoteRecv(byte[] buffer, int len) throws IOException {
        return this.remoteTcp.recv(buffer, len);
    }

    int remoteSend(byte[] data, int len) throws IOException {
        return this.remoteTcp.send(data, len);
    }

    private void localPacket(byte[] data, int len) throws IOException {
        this.localTcp.notifyPacket(data, len);
        this.updateLocalClock();
    }

    private void remotePacket(byte[] data, int len) throws IOException {
        this.remoteTcp.notifyPacket(data, len);
        this.updateRemoteClock();
    }

    private TimerTask getWriteRemotePacketTask(final byte[] data, final int len) {
        return new TimerTask(){

            public void run() {
                try {
                    PseudoTcpTestBase.this.remotePacket(data, len);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    private TimerTask getWriteLocalPacketTask(final byte[] data, final int len) {
        return new TimerTask(){

            public void run() {
                try {
                    PseudoTcpTestBase.this.localPacket(data, len);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public WriteResult tcpWritePacket(PseudoTCPBase tcp, byte[] buffer, int len) {
        if (this.randomInt() < this.loss_) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Randomly dropping packet, size=" + len);
            }
        } else if (len > Math.min(this.local_mtu_, this.remote_mtu_)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Dropping packet that exceeds path MTU, size=" + len);
            }
        } else if (tcp == this.localTcp) {
            this.timer.schedule(this.getWriteRemotePacketTask(buffer, len), this.delay_);
        } else {
            this.timer.schedule(this.getWriteLocalPacketTask(buffer, len), this.delay_);
        }
        return WriteResult.WR_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocalClock() {
        if (this.localClockThread != null) {
            Object object = this.localClockLock;
            synchronized (object) {
                this.localClockLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRemoteClock() {
        if (this.remoteClockThread != null) {
            Object object = this.remoteClockLock;
            synchronized (object) {
                this.remoteClockLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNextClock(PseudoTCPBase tcp, Object lock) {
        try {
            long interval;
            long now = PseudoTCPBase.now();
            PseudoTCPBase pseudoTCPBase = tcp;
            synchronized (pseudoTCPBase) {
                tcp.notifyClock(now);
            }
            Object object = tcp;
            synchronized (object) {
                interval = tcp.getNextClock(PseudoTCPBase.now());
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, tcp.debugName + " CLOCK sleep for " + interval);
            }
            if (interval < 0L) {
                if (interval == -1L) {
                    interval = 1000L;
                } else {
                    return;
                }
            }
            object = lock;
            synchronized (object) {
                lock.wait(interval);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void startClocks() {
        if (this.localClockThread != null || this.remoteClockThread != null) {
            throw new IllegalStateException();
        }
        this.runClocks = true;
        this.localClockThread = new Thread(new Runnable(){

            public void run() {
                while (PseudoTcpTestBase.this.runClocks) {
                    PseudoTcpTestBase.this.updateNextClock(PseudoTcpTestBase.this.localTcp, PseudoTcpTestBase.this.localClockLock);
                }
            }
        }, "LocalClockThread");
        this.remoteClockThread = new Thread(new Runnable(){

            public void run() {
                while (PseudoTcpTestBase.this.runClocks) {
                    PseudoTcpTestBase.this.updateNextClock(PseudoTcpTestBase.this.remoteTcp, PseudoTcpTestBase.this.remoteClockLock);
                }
            }
        }, "RemoteClockThread");
        this.localClockThread.start();
        this.remoteClockThread.start();
    }

    protected void stopClocks() {
        if (this.localClockThread != null && this.remoteClockThread != null) {
            try {
                this.runClocks = false;
                this.localClockThread.interrupt();
                this.remoteClockThread.interrupt();
                this.localClockThread.join();
                this.localClockThread = null;
                this.remoteClockThread.join();
                this.remoteClockThread = null;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    protected boolean assert_Connected_wait(int kConnectTimeoutMs) {
        return this.assert_wait_until(new MultiThreadSupportTest.WaitUntilDone(){

            public boolean isDone() {
                return PseudoTcpTestBase.this.have_connected_;
            }
        }, kConnectTimeoutMs);
    }

    protected boolean assert_Disconnected_wait(long kTransferTimeoutMs) {
        return this.assert_wait_until(new MultiThreadSupportTest.WaitUntilDone(){

            public boolean isDone() {
                return PseudoTcpTestBase.this.have_disconnected_;
            }
        }, kTransferTimeoutMs);
    }

    PseudoTCPBase getRemoteTcp() {
        return this.remoteTcp;
    }

    PseudoTCPBase getLocalTcp() {
        return this.localTcp;
    }

    public long maxTransferTime(long size, long kBps) {
        long transferTout = size / kBps * 8L * 1000L;
        return transferTout > 3000L ? transferTout : 3000L;
    }
}

