/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stunclient;

import junit.framework.TestCase;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stunclient.NetworkConfigurationDiscoveryProcess;
import org.ice4j.stunclient.ResponseSequenceServer;
import org.ice4j.stunclient.StunDiscoveryReport;

public class StunAddressDiscovererTest_v4v6
extends TestCase {
    private NetworkConfigurationDiscoveryProcess stunAddressDiscoverer_v6 = null;
    private NetworkConfigurationDiscoveryProcess stunAddressDiscoverer_v4 = null;
    private TransportAddress discovererAddress_v4 = new TransportAddress("127.0.0.1", 17555, Transport.UDP);
    private TransportAddress discovererAddress_v6 = new TransportAddress("::1", 17555, Transport.UDP);
    private ResponseSequenceServer responseServer_v6 = null;
    private ResponseSequenceServer responseServer_v4 = null;
    private TransportAddress responseServerAddress_v6 = new TransportAddress("::1", 21999, Transport.UDP);
    private TransportAddress responseServerAddress_v4 = new TransportAddress("127.0.0.1", 21999, Transport.UDP);
    private TransportAddress mappedClientAddress_v6 = new TransportAddress("2001:660:4701:1001:ff::1", 17612, Transport.UDP);
    private TransportAddress mappedClientAddress_v6_Port2 = new TransportAddress("2001:660:4701:1001:ff::1", 17611, Transport.UDP);
    private TransportAddress mappedClientAddress_v4 = new TransportAddress("130.79.99.55", 17612, Transport.UDP);
    private TransportAddress mappedClientAddress_v4_Port2 = new TransportAddress("130.79.99.55", 17611, Transport.UDP);

    public StunAddressDiscovererTest_v4v6(String name) throws StunException {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        StunStack stunStack = new StunStack();
        this.responseServer_v6 = new ResponseSequenceServer(stunStack, this.responseServerAddress_v6);
        this.responseServer_v4 = new ResponseSequenceServer(stunStack, this.responseServerAddress_v4);
        this.stunAddressDiscoverer_v6 = new NetworkConfigurationDiscoveryProcess(stunStack, this.discovererAddress_v6, this.responseServerAddress_v6);
        this.stunAddressDiscoverer_v4 = new NetworkConfigurationDiscoveryProcess(stunStack, this.discovererAddress_v4, this.responseServerAddress_v4);
        this.stunAddressDiscoverer_v6.start();
        this.stunAddressDiscoverer_v4.start();
        this.responseServer_v6.start();
        this.responseServer_v4.start();
        System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "100");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "2");
    }

    protected void tearDown() throws Exception {
        System.clearProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER");
        System.clearProperty("org.ice4j.MAX_RETRANSMISSIONS");
        this.responseServer_v6.shutDown();
        this.responseServer_v4.shutDown();
        this.stunAddressDiscoverer_v6.shutDown();
        this.stunAddressDiscoverer_v6 = null;
        this.stunAddressDiscoverer_v4.shutDown();
        this.stunAddressDiscoverer_v4 = null;
        Thread.sleep(1000L);
        super.tearDown();
    }

    public void testRecognizeSymmetricNat_Local_v6_Public_v4() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v4, this.responseServerAddress_v6, this.responseServerAddress_v6);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v4_Port2, this.responseServerAddress_v6, this.responseServerAddress_v6);
        this.responseServer_v6.addMessage(testIResponse1);
        this.responseServer_v6.addMessage(testIResponse2);
        this.responseServer_v6.addMessage(testIResponse3);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v4);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v6.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a v4-v6 sym env.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeSymmetricNat_Local_v4_Public_v6() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v6, this.responseServerAddress_v4, this.responseServerAddress_v4);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v6_Port2, this.responseServerAddress_v4, this.responseServerAddress_v4);
        this.responseServer_v4.addMessage(testIResponse1);
        this.responseServer_v4.addMessage(testIResponse2);
        this.responseServer_v4.addMessage(testIResponse3);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v6);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v4.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeFullCone_Local_v6_Public_v4() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v4, this.responseServerAddress_v6, this.responseServerAddress_v6);
        Response testIResponse2 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v4, this.responseServerAddress_v6, this.responseServerAddress_v6);
        this.responseServer_v6.addMessage(testIResponse1);
        this.responseServer_v6.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Full Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v4);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v6.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeFullCone_Local_v4_Public_v6() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v6, this.responseServerAddress_v4, this.responseServerAddress_v4);
        Response testIResponse2 = MessageFactory.create3489BindingResponse(this.mappedClientAddress_v6, this.responseServerAddress_v4, this.responseServerAddress_v4);
        this.responseServer_v4.addMessage(testIResponse1);
        this.responseServer_v4.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Full Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress_v6);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer_v4.determineAddress();
        StunAddressDiscovererTest_v4v6.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }
}

