/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import org.ice4j.StunException;
import org.ice4j.TransportAddress;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

class StunServerTransaction
implements Runnable {
    private long transactionLifetime = 16000L;
    private StunStack stackCallback = null;
    private TransportAddress responseDestination = null;
    private TransportAddress requestSource = null;
    private Response response = null;
    private TransportAddress localListeningAddress = null;
    private TransportAddress localSendingAddress = null;
    private TransactionID transactionID = null;
    private long expirationDate = -1L;
    private Thread runningThread = null;
    private boolean expired = true;
    private boolean isRetransmitting = false;

    public StunServerTransaction(StunStack stackCallback, TransactionID tranID, TransportAddress localListeningAddress, TransportAddress requestSource) {
        this.stackCallback = stackCallback;
        this.transactionID = tranID;
        this.requestSource = requestSource;
        this.localListeningAddress = localListeningAddress;
        this.requestSource = requestSource;
        this.runningThread = new Thread((Runnable)this, "StunServerTransaction@" + this.hashCode());
        this.runningThread.setDaemon(true);
    }

    public void start() {
        this.expired = false;
        this.runningThread.start();
    }

    public void run() {
        this.runningThread.setName("ServTran");
        this.schedule(this.transactionLifetime);
        this.waitNextScheduledDate();
        this.expire();
        this.stackCallback.removeServerTransaction(this);
    }

    public void sendResponse(Response response, TransportAddress sendThrough, TransportAddress sendTo) throws StunException, IOException, IllegalArgumentException {
        if (!this.isRetransmitting) {
            this.response = response;
            response.setTransactionID(this.transactionID.getBytes());
            this.localSendingAddress = sendThrough;
            this.responseDestination = sendTo;
        }
        this.isRetransmitting = true;
        this.retransmitResponse();
    }

    protected void retransmitResponse() throws StunException, IOException, IllegalArgumentException {
        if (this.expired || !this.isRetransmitting) {
            return;
        }
        this.stackCallback.getNetAccessManager().sendMessage(this.response, this.localSendingAddress, this.responseDestination);
    }

    private synchronized void waitNextScheduledDate() {
        long current = System.currentTimeMillis();
        while (this.expirationDate - current > 0L) {
            try {
                this.wait(this.expirationDate - current);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.expired) {
                return;
            }
            current = System.currentTimeMillis();
        }
    }

    private void schedule(long timeout) {
        this.expirationDate = System.currentTimeMillis() + timeout;
    }

    public synchronized void expire() {
        this.expired = true;
        this.notifyAll();
    }

    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    public boolean isRetransmitting() {
        return this.isRetransmitting;
    }

    public TransportAddress getSendingAddress() {
        return this.localSendingAddress;
    }

    public TransportAddress getResponseDestinationAddress() {
        return this.responseDestination;
    }

    public TransportAddress getLocalListeningAddress() {
        return this.localListeningAddress;
    }

    public TransportAddress getRequestSourceAddress() {
        return this.requestSource;
    }

    protected Response getResponse() {
        return this.response;
    }
}

