/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.RelayedCandidate;

public class DefaultNominator
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(DefaultNominator.class.getName());
    private final Agent parentAgent;
    private NominationStrategy strategy = NominationStrategy.NOMINATE_FIRST_VALID;
    private Map<String, TimerTask> validatedCandidates = new HashMap<String, TimerTask>();

    public DefaultNominator(Agent parentAgent) {
        this.parentAgent = parentAgent;
        parentAgent.addStateChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        CandidatePair validPair;
        if ("IceProcessingState".equals(evt.getPropertyName())) {
            IceProcessingState newState = (IceProcessingState)((Object)evt.getNewValue());
            if (newState != IceProcessingState.RUNNING) {
                return;
            }
            List<IceMediaStream> streams = this.parentAgent.getStreams();
            for (IceMediaStream stream : streams) {
                stream.addPairChangeListener(this);
                stream.getCheckList().addStateChangeListener(this);
            }
        }
        if (!this.parentAgent.isControlling() || this.strategy == NominationStrategy.NONE) {
            return;
        }
        if (evt.getSource() instanceof CandidatePair && (validPair = (CandidatePair)evt.getSource()).getParentComponent().getSelectedPair() != null) {
            logger.fine("Keep-alive for pair: " + validPair.toShortString());
            return;
        }
        if (this.strategy == NominationStrategy.NOMINATE_FIRST_VALID) {
            this.strategyNominateFirstValid(evt);
        } else if (this.strategy == NominationStrategy.NOMINATE_HIGHEST_PRIO) {
            this.strategyNominateHighestPrio(evt);
        } else if (this.strategy == NominationStrategy.NOMINATE_FIRST_HOST_OR_REFLEXIVE_VALID) {
            this.strategyNominateFirstHostOrReflexiveValid(evt);
        }
    }

    private void strategyNominateFirstValid(PropertyChangeEvent evt) {
        if ("PairValidated".equals(evt.getPropertyName())) {
            CandidatePair validPair = (CandidatePair)evt.getSource();
            logger.info("Nominate (first valid): " + validPair.toShortString());
            this.parentAgent.nominate(validPair);
        }
    }

    private void strategyNominateHighestPrio(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("PairValidated".equals(propName) || "PairStateChanged".equals(propName) && (CandidatePairState)((Object)evt.getNewValue()) == CandidatePairState.FAILED) {
            CandidatePair validPair = (CandidatePair)evt.getSource();
            Component parentComponent = validPair.getParentComponent();
            IceMediaStream parentStream = parentComponent.getParentStream();
            CheckList parentCheckList = parentStream.getCheckList();
            if (!parentCheckList.allChecksCompleted()) {
                return;
            }
            List<Component> components = parentStream.getComponents();
            for (Component component : components) {
                CandidatePair pair = parentStream.getValidPair(component);
                if (pair == null) continue;
                logger.info("Nominate (highest priority): " + validPair.toShortString());
                this.parentAgent.nominate(pair);
            }
        }
    }

    public void setStrategy(NominationStrategy strategy) {
        this.strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strategyNominateFirstHostOrReflexiveValid(PropertyChangeEvent evt) {
        if ("PairValidated".equals(evt.getPropertyName())) {
            CandidatePair validPair = (CandidatePair)evt.getSource();
            TimerTask task = null;
            boolean isRelayed = validPair.getLocalCandidate() instanceof RelayedCandidate || validPair.getLocalCandidate().getType().equals((Object)CandidateType.RELAYED_CANDIDATE) || validPair.getRemoteCandidate().getType().equals((Object)CandidateType.RELAYED_CANDIDATE);
            boolean nominate = false;
            Map<String, TimerTask> map = this.validatedCandidates;
            synchronized (map) {
                task = this.validatedCandidates.get(validPair.getParentComponent().toShortString());
                if (isRelayed && task == null) {
                    Timer timer = new Timer();
                    task = new RelayedCandidateTask(validPair);
                    logger.info("Wait timeout to nominate relayed candidate");
                    timer.schedule(task, 0L);
                    this.validatedCandidates.put(validPair.getParentComponent().toShortString(), task);
                } else if (!isRelayed) {
                    if (task != null) {
                        task.cancel();
                        logger.info("Found a better candidate pair to nominate for " + validPair.getParentComponent().toShortString());
                    }
                    logger.info("Nominate (first highest valid): " + validPair.toShortString());
                    nominate = true;
                }
            }
            if (nominate) {
                this.parentAgent.nominate(validPair);
            }
        }
    }

    private class RelayedCandidateTask
    extends TimerTask
    implements PropertyChangeListener {
        private static final int WAIT_TIME = 800;
        private final CandidatePair pair;
        private boolean canceled = false;

        public RelayedCandidateTask(CandidatePair pair) {
            this.pair = pair;
            pair.getParentComponent().getParentStream().getCheckList().addChecksListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            CheckList checkList = (CheckList)evt.getSource();
            boolean allFailed = true;
            CheckList checkList2 = checkList;
            synchronized (checkList2) {
                for (CandidatePair c : checkList) {
                    if (c == this.pair || c.getState() == CandidatePairState.FAILED) continue;
                    allFailed = false;
                }
            }
            if (allFailed && !this.pair.isNominated()) {
                this.cancel();
                logger.info("Nominate (first highest valid): " + this.pair.toShortString());
                DefaultNominator.this.parentAgent.nominate(this.pair);
            }
        }

        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        public void run() {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                this.canceled = true;
            }
            this.pair.getParentComponent().getParentStream().getCheckList().removeChecksListener(this);
            DefaultNominator.this.validatedCandidates.remove(this.pair.getParentComponent().toShortString());
            if (this.canceled) {
                return;
            }
            logger.info("Nominate (first highest valid): " + this.pair.toShortString());
            DefaultNominator.this.parentAgent.nominate(this.pair);
        }
    }
}

