/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.attribute.RealmAttribute;

public class RealmAttributeTest
extends TestCase {
    private RealmAttribute realmAttribute = null;
    MsgFixture msgFixture = null;
    String realmValue = "domain.org";
    byte[] attributeBinValue = new byte[]{0, 20, 0, (byte)this.realmValue.length(), 100, 111, 109, 97, 105, 110, 46, 111, 114, 103, 0, 0};

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.realmAttribute = new RealmAttribute();
        this.realmAttribute.setRealm(this.realmValue.getBytes());
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.realmAttribute = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeAttributeBody() throws StunException {
        char offset = '\u0000';
        RealmAttribute decoded = new RealmAttribute();
        char length = (char)this.realmValue.length();
        decoded.decodeAttributeBody(this.realmValue.getBytes(), offset, length);
        RealmAttributeTest.assertEquals((String)"decode failed", (Object)this.realmAttribute, (Object)decoded);
    }

    public void testEncode() {
        RealmAttributeTest.assertTrue((String)"encode failed", (boolean)Arrays.equals(this.realmAttribute.encode(), this.attributeBinValue));
    }

    public void testEquals() {
        RealmAttribute realmAttribute2 = new RealmAttribute();
        realmAttribute2.setRealm(this.realmValue.getBytes());
        RealmAttributeTest.assertEquals((String)"testequals failed", (Object)this.realmAttribute, (Object)realmAttribute2);
        realmAttribute2 = new RealmAttribute();
        realmAttribute2.setRealm("some other realm".getBytes());
        RealmAttributeTest.assertFalse((String)"testequals failed", (boolean)this.realmAttribute.equals(realmAttribute2));
        RealmAttributeTest.assertFalse((String)"testequals failed", (boolean)this.realmAttribute.equals(null));
    }

    public void testGetDataLength() {
        char expectedReturn = (char)this.realmValue.length();
        char actualReturn = this.realmAttribute.getDataLength();
        RealmAttributeTest.assertEquals((String)"getDataLength - failed", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "REALM";
        String actualReturn = this.realmAttribute.getName();
        RealmAttributeTest.assertEquals((String)"getting name failed", (String)expectedReturn, (String)actualReturn);
    }

    public void testSetGetRealm() {
        byte[] expectedReturn = this.realmValue.getBytes();
        RealmAttribute att = new RealmAttribute();
        att.setRealm(expectedReturn);
        byte[] actualReturn = att.getRealm();
        RealmAttributeTest.assertTrue((String)"realm setter or getter failed", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }
}

