/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.jabber;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.EncodingsRegistrationUtil;
import net.java.sip.communicator.service.protocol.JingleNodeDescriptor;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.SecurityAccountRegistration;
import net.java.sip.communicator.service.protocol.StunServerDescriptor;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountID;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaService;
import org.osgi.framework.BundleContext;

public class JabberAccountRegistration
extends JabberAccountID
implements Serializable {
    private String defaultUserSufix;
    private boolean rememberPassword = true;
    private String editedAccUID;
    private List<StunServerDescriptor> additionalStunServers = new ArrayList<StunServerDescriptor>();
    private List<JingleNodeDescriptor> additionalJingleNodes = new ArrayList<JingleNodeDescriptor>();
    private EncodingsRegistrationUtil encodingsRegistration = new EncodingsRegistrationUtil();
    private SecurityAccountRegistration securityRegistration = new SecurityAccountRegistration(){

        @Override
        public void setSavpOption(int savpOption) {
        }

        @Override
        public int getSavpOption() {
            return 0;
        }
    };

    public JabberAccountRegistration() {
        super(null, new HashMap<String, String>());
    }

    @Override
    public String getAccountUniqueID() {
        return this.editedAccUID;
    }

    public String getDefaultUserSufix() {
        return this.defaultUserSufix;
    }

    public void setUserID(String userID) {
        this.setOrRemoveIfEmpty("USER_ID", userID);
    }

    @Override
    public String getUserID() {
        return this.getAccountPropertyString("USER_ID");
    }

    public void setDefaultUserSufix(String userSufix) {
        this.defaultUserSufix = userSufix;
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
    }

    public void addStunServer(StunServerDescriptor stunServer) {
        this.additionalStunServers.add(stunServer);
    }

    public List<StunServerDescriptor> getAdditionalStunServers() {
        return this.additionalStunServers;
    }

    public void addJingleNodes(JingleNodeDescriptor node) {
        this.additionalJingleNodes.add(node);
    }

    public List<JingleNodeDescriptor> getAdditionalJingleNodes() {
        return this.additionalJingleNodes;
    }

    public EncodingsRegistrationUtil getEncodingsRegistration() {
        return this.encodingsRegistration;
    }

    public SecurityAccountRegistration getSecurityRegistration() {
        return this.securityRegistration;
    }

    public void storeProperties(String userName, String passwd, String protocolIconPath, String accountIconPath, Map<String, String> accountProperties) throws OperationFailedException {
        if (this.rememberPassword) {
            this.setPassword(passwd);
        } else {
            this.setPassword(null);
        }
        String serverName = null;
        serverName = this.getServerAddress() != null && this.getServerAddress().length() > 0 ? this.getServerAddress() : this.getServerFromUserName(userName);
        if (serverName == null || serverName.length() <= 0) {
            throw new OperationFailedException("Should specify a server for user name " + userName + ".", 17);
        }
        BundleContext bContext = ProtocolProviderActivator.getBundleContext();
        ProtocolProviderFactory jbfFactory = ProtocolProviderFactory.getProtocolProviderFactory(bContext, "Jabber");
        AccountManager accManager = ProtocolProviderActivator.getAccountManager();
        String accountNodeName = accManager.getAccountNodeName(jbfFactory, this.editedAccUID);
        if (accountNodeName != null) {
            String[] accKeys;
            ConfigurationService configSrvc = ProtocolProviderActivator.getConfigurationService();
            String factoryPackage = accManager.getFactoryImplPackageName(jbfFactory);
            String accountPrefix = factoryPackage + "." + accountNodeName;
            List allProperties = configSrvc.getAllPropertyNames();
            String stunPrefix = accountPrefix + "." + "STUN";
            String jinglePrefix = accountPrefix + "." + "JINGLENODES";
            for (String property : allProperties) {
                if (!property.startsWith(stunPrefix) && !property.startsWith(jinglePrefix)) continue;
                configSrvc.removeProperty(property);
            }
            for (String property : accKeys = this.accountProperties.keySet().toArray(new String[accountProperties.size()])) {
                if (!property.startsWith("STUN") && !property.startsWith("JINGLENODES")) continue;
                this.accountProperties.remove(property);
            }
        }
        List<StunServerDescriptor> stunServers = this.getAdditionalStunServers();
        int serverIndex = -1;
        for (StunServerDescriptor stunServer : stunServers) {
            stunServer.storeDescriptor(this.accountProperties, "STUN" + ++serverIndex);
        }
        List<JingleNodeDescriptor> jnRelays = this.getAdditionalJingleNodes();
        serverIndex = -1;
        for (JingleNodeDescriptor jnRelay : jnRelays) {
            jnRelay.storeDescriptor(this.accountProperties, "JINGLENODES" + ++serverIndex);
        }
        this.securityRegistration.storeProperties(this.accountProperties);
        this.encodingsRegistration.storeProperties(this.accountProperties);
        super.storeProperties(protocolIconPath, accountIconPath, accountProperties);
    }

    public void loadAccount(AccountID account, BundleContext bundleContext) {
        JingleNodeDescriptor jn;
        StunServerDescriptor stunServer;
        int i;
        JabberAccountRegistration.mergeProperties(account.getAccountProperties(), this.accountProperties);
        String password = ProtocolProviderFactory.getProtocolProviderFactory(bundleContext, "Jabber").loadPassword(account);
        this.setUserID(account.getUserID());
        this.editedAccUID = account.getAccountUniqueID();
        this.setPassword(password);
        this.rememberPassword = password != null;
        this.securityRegistration.loadAccount(account);
        this.additionalStunServers.clear();
        for (i = 0; i < 100 && (stunServer = StunServerDescriptor.loadDescriptor(this.accountProperties, "STUN" + i)) != null; ++i) {
            String stunPassword = JabberAccountRegistration.loadStunPassword(bundleContext, account, "STUN" + i);
            if (stunPassword != null) {
                stunServer.setPassword(stunPassword);
            }
            this.addStunServer(stunServer);
        }
        this.additionalJingleNodes.clear();
        for (i = 0; i < 100 && (jn = JingleNodeDescriptor.loadDescriptor(this.accountProperties, "JINGLENODES" + i)) != null; ++i) {
            this.addJingleNodes(jn);
        }
        this.encodingsRegistration.loadAccount(account, (MediaService)ServiceUtils.getService((BundleContext)bundleContext, MediaService.class));
    }

    private static String loadStunPassword(BundleContext bundleContext, AccountID accountID, String namePrefix) {
        ProtocolProviderFactory providerFactory = ProtocolProviderFactory.getProtocolProviderFactory(bundleContext, "Jabber");
        String password = null;
        String className = providerFactory.getClass().getName();
        String packageSourceName = className.substring(0, className.lastIndexOf(46));
        String accountPrefix = ProtocolProviderFactory.findAccountPrefix(bundleContext, accountID, packageSourceName);
        CredentialsStorageService credentialsService = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        try {
            password = credentialsService.loadPassword(accountPrefix + "." + namePrefix);
        }
        catch (Exception e) {
            return null;
        }
        return password;
    }

    protected String getServerFromUserName(String userName) {
        int delimIndex = userName.indexOf("@");
        if (delimIndex != -1) {
            String newServerAddr = userName.substring(delimIndex + 1);
            if (newServerAddr.equals("gmail.com")) {
                return "talk.google.com";
            }
            return newServerAddr;
        }
        return null;
    }
}

