/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomConferencePublishedListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;

public interface ChatRoom {
    public String getName();

    public String getIdentifier();

    public void join() throws OperationFailedException;

    public void join(byte[] var1) throws OperationFailedException;

    public void joinAs(String var1) throws OperationFailedException;

    public void joinAs(String var1, byte[] var2) throws OperationFailedException;

    public boolean isJoined();

    public void leave();

    public String getSubject();

    public void setSubject(String var1) throws OperationFailedException;

    public String getUserNickname();

    public ChatRoomMemberRole getUserRole();

    public void setLocalUserRole(ChatRoomMemberRole var1) throws OperationFailedException;

    public void setUserNickname(String var1) throws OperationFailedException;

    public void addMemberPresenceListener(ChatRoomMemberPresenceListener var1);

    public void removeMemberPresenceListener(ChatRoomMemberPresenceListener var1);

    public void addLocalUserRoleListener(ChatRoomLocalUserRoleListener var1);

    public void removelocalUserRoleListener(ChatRoomLocalUserRoleListener var1);

    public void addMemberRoleListener(ChatRoomMemberRoleListener var1);

    public void removeMemberRoleListener(ChatRoomMemberRoleListener var1);

    public void addPropertyChangeListener(ChatRoomPropertyChangeListener var1);

    public void removePropertyChangeListener(ChatRoomPropertyChangeListener var1);

    public void addMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener var1);

    public void removeMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener var1);

    public void invite(String var1, String var2);

    public List<ChatRoomMember> getMembers();

    public int getMembersCount();

    public void addMessageListener(ChatRoomMessageListener var1);

    public void removeMessageListener(ChatRoomMessageListener var1);

    public Message createMessage(byte[] var1, String var2, String var3, String var4);

    public Message createMessage(String var1);

    public void sendMessage(Message var1) throws OperationFailedException;

    public ProtocolProviderService getParentProvider();

    public Iterator<ChatRoomMember> getBanList() throws OperationFailedException;

    public void banParticipant(ChatRoomMember var1, String var2) throws OperationFailedException;

    public void kickParticipant(ChatRoomMember var1, String var2) throws OperationFailedException;

    public ChatRoomConfigurationForm getConfigurationForm() throws OperationFailedException;

    public boolean isSystem();

    public boolean isPersistent();

    public Contact getPrivateContactByNickname(String var1);

    public void grantAdmin(String var1);

    public void grantMembership(String var1);

    public void grantModerator(String var1);

    public void grantOwnership(String var1);

    public void grantVoice(String var1);

    public void revokeAdmin(String var1);

    public void revokeMembership(String var1);

    public void revokeModerator(String var1);

    public void revokeOwnership(String var1);

    public void revokeVoice(String var1);

    public ConferenceDescription publishConference(ConferenceDescription var1, String var2);

    public void updatePrivateContactPresenceStatus(String var1);

    public void updatePrivateContactPresenceStatus(Contact var1);

    public void addConferencePublishedListener(ChatRoomConferencePublishedListener var1);

    public void removeConferencePublishedListener(ChatRoomConferencePublishedListener var1);

    public Map<String, ConferenceDescription> getCachedConferenceDescriptions();

    public int getCachedConferenceDescriptionSize();
}

