/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationRejectedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomInvitationRejectionListener;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;

public abstract class AbstractOperationSetMultiUserChat
implements OperationSetMultiUserChat {
    private final List<ChatRoomInvitationListener> invitationListeners = new Vector<ChatRoomInvitationListener>();
    private final List<ChatRoomInvitationRejectionListener> invitationRejectionListeners = new Vector<ChatRoomInvitationRejectionListener>();
    private final List<LocalUserChatRoomPresenceListener> presenceListeners = new Vector<LocalUserChatRoomPresenceListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvitationListener(ChatRoomInvitationListener listener) {
        List<ChatRoomInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            if (!this.invitationListeners.contains(listener)) {
                this.invitationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvitationRejectionListener(ChatRoomInvitationRejectionListener listener) {
        List<ChatRoomInvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            if (!this.invitationRejectionListeners.contains(listener)) {
                this.invitationRejectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPresenceListener(LocalUserChatRoomPresenceListener listener) {
        List<LocalUserChatRoomPresenceListener> list = this.presenceListeners;
        synchronized (list) {
            if (!this.presenceListeners.contains(listener)) {
                this.presenceListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInvitationReceived(ChatRoomInvitation invitation) {
        ChatRoomInvitationListener[] listeners;
        ChatRoomInvitationReceivedEvent evt = new ChatRoomInvitationReceivedEvent(this, invitation, new Date(System.currentTimeMillis()));
        List<ChatRoomInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            listeners = this.invitationListeners.toArray(new ChatRoomInvitationListener[this.invitationListeners.size()]);
        }
        for (ChatRoomInvitationListener listener : listeners) {
            listener.invitationReceived(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInvitationRejectedEvent(ChatRoom sourceChatRoom, String invitee, String reason) {
        ChatRoomInvitationRejectionListener[] listeners;
        ChatRoomInvitationRejectedEvent evt = new ChatRoomInvitationRejectedEvent(this, sourceChatRoom, invitee, reason, new Date(System.currentTimeMillis()));
        List<ChatRoomInvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            listeners = this.invitationRejectionListeners.toArray(new ChatRoomInvitationRejectionListener[this.invitationRejectionListeners.size()]);
        }
        for (ChatRoomInvitationRejectionListener listener : listeners) {
            listener.invitationRejected(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireLocalUserPresenceEvent(ChatRoom chatRoom, String eventType, String reason) {
        LocalUserChatRoomPresenceListener[] listeners;
        LocalUserChatRoomPresenceChangeEvent evt = new LocalUserChatRoomPresenceChangeEvent(this, chatRoom, eventType, reason);
        List<LocalUserChatRoomPresenceListener> list = this.presenceListeners;
        synchronized (list) {
            listeners = this.presenceListeners.toArray(new LocalUserChatRoomPresenceListener[this.presenceListeners.size()]);
        }
        for (LocalUserChatRoomPresenceListener listener : listeners) {
            listener.localUserPresenceChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInvitationListener(ChatRoomInvitationListener listener) {
        List<ChatRoomInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInvitationRejectionListener(ChatRoomInvitationRejectionListener listener) {
        List<ChatRoomInvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            this.invitationRejectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePresenceListener(LocalUserChatRoomPresenceListener listener) {
        List<LocalUserChatRoomPresenceListener> list = this.presenceListeners;
        synchronized (list) {
            this.presenceListeners.remove(listener);
        }
    }
}

