/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketReader;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.util.ExceptionUtil;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

class SocketPacketReader
implements SocketReader {
    Packet packet = null;
    final PacketReader packetReader;
    final TcpIpConnection connection;
    final IOService ioService;
    final ILogger logger;

    public SocketPacketReader(TcpIpConnection connection) {
        this.connection = connection;
        this.ioService = connection.getConnectionManager().ioService;
        this.logger = this.ioService.getLogger(this.getClass().getName());
        boolean symmetricEncryptionEnabled = CipherHelper.isSymmetricEncryptionEnabled(this.ioService);
        if (symmetricEncryptionEnabled) {
            this.packetReader = new SymmetricCipherPacketReader();
            this.logger.info("Reader started with SymmetricEncryption");
        } else {
            this.packetReader = new DefaultPacketReader();
        }
    }

    @Override
    public void read(ByteBuffer inBuffer) throws Exception {
        this.packetReader.readPacket(inBuffer);
    }

    private void enqueueFullPacket(Packet p) {
        p.setConn(this.connection);
        this.ioService.handleMemberPacket(p);
    }

    public Packet obtainReadable() {
        return new Packet(this.ioService.getSerializationContext());
    }

    private class SymmetricCipherPacketReader
    implements PacketReader {
        int size = -1;
        final Cipher cipher;
        ByteBuffer cipherBuffer;

        private SymmetricCipherPacketReader() {
            this.cipherBuffer = ByteBuffer.allocate(SocketPacketReader.this.ioService.getSocketReceiveBufferSize() * 1024);
            this.cipher = this.init();
        }

        Cipher init() {
            Cipher c;
            try {
                c = CipherHelper.createSymmetricReaderCipher(SocketPacketReader.this.ioService.getSymmetricEncryptionConfig());
            }
            catch (Exception e) {
                SocketPacketReader.this.logger.severe("Symmetric Cipher for ReadHandler cannot be initialized.", e);
                CipherHelper.handleCipherException(e, SocketPacketReader.this.connection);
                throw ExceptionUtil.rethrow(e);
            }
            return c;
        }

        @Override
        public void readPacket(ByteBuffer inBuffer) throws Exception {
            while (inBuffer.hasRemaining()) {
                try {
                    int remaining;
                    if (this.size == -1) {
                        if (inBuffer.remaining() < 4) {
                            return;
                        }
                        this.size = inBuffer.getInt();
                        if (this.cipherBuffer.capacity() < this.size) {
                            this.cipherBuffer = ByteBuffer.allocate(this.size);
                        }
                    }
                    if ((remaining = inBuffer.remaining()) < this.size) {
                        this.cipher.update(inBuffer, this.cipherBuffer);
                        this.size -= remaining;
                    } else if (remaining == this.size) {
                        this.cipher.doFinal(inBuffer, this.cipherBuffer);
                        this.size = -1;
                    } else {
                        int oldLimit = inBuffer.limit();
                        int newLimit = inBuffer.position() + this.size;
                        inBuffer.limit(newLimit);
                        this.cipher.doFinal(inBuffer, this.cipherBuffer);
                        inBuffer.limit(oldLimit);
                        this.size = -1;
                    }
                }
                catch (ShortBufferException e) {
                    SocketPacketReader.this.logger.warning(e);
                }
                this.cipherBuffer.flip();
                while (this.cipherBuffer.hasRemaining()) {
                    boolean complete;
                    if (SocketPacketReader.this.packet == null) {
                        SocketPacketReader.this.packet = SocketPacketReader.this.obtainReadable();
                    }
                    if (!(complete = SocketPacketReader.this.packet.readFrom(this.cipherBuffer))) continue;
                    SocketPacketReader.this.enqueueFullPacket(SocketPacketReader.this.packet);
                    SocketPacketReader.this.packet = null;
                }
                this.cipherBuffer.clear();
            }
        }
    }

    private class DefaultPacketReader
    implements PacketReader {
        private DefaultPacketReader() {
        }

        @Override
        public void readPacket(ByteBuffer inBuffer) {
            while (inBuffer.hasRemaining()) {
                boolean complete;
                if (SocketPacketReader.this.packet == null) {
                    SocketPacketReader.this.packet = SocketPacketReader.this.obtainReadable();
                }
                if (!(complete = SocketPacketReader.this.packet.readFrom(inBuffer))) break;
                SocketPacketReader.this.enqueueFullPacket(SocketPacketReader.this.packet);
                SocketPacketReader.this.packet = null;
            }
        }
    }

    private static interface PacketReader {
        public void readPacket(ByteBuffer var1) throws Exception;
    }
}

