/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.multimap.MultiMapWrapper;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class MultiMapContainer {
    final String name;
    final MultiMapService service;
    final NodeEngine nodeEngine;
    final MultiMapConfig config;
    final ConcurrentMap<Data, MultiMapWrapper> multiMapWrappers = new ConcurrentHashMap<Data, MultiMapWrapper>(1000);
    final DefaultObjectNamespace lockNamespace;
    final LockStore lockStore;
    final int partitionId;
    final AtomicLong idGen = new AtomicLong();
    final AtomicLong lastAccessTime = new AtomicLong();
    final AtomicLong lastUpdateTime = new AtomicLong();
    final long creationTime;

    public MultiMapContainer(String name, MultiMapService service, int partitionId) {
        this.name = name;
        this.service = service;
        this.nodeEngine = service.getNodeEngine();
        this.partitionId = partitionId;
        this.config = this.nodeEngine.getConfig().findMultiMapConfig(name);
        this.lockNamespace = new DefaultObjectNamespace("hz:impl:multiMapService", name);
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionId, this.lockNamespace);
        this.creationTime = Clock.currentTimeMillis();
    }

    public boolean canAcquireLock(Data dataKey, String caller, int threadId) {
        return this.lockStore != null && this.lockStore.canAcquireLock(dataKey, caller, threadId);
    }

    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    public boolean txnLock(Data key, String caller, int threadId, long ttl) {
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    public boolean unlock(Data key, String caller, int threadId) {
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    public boolean forceUnlock(Data key) {
        return this.lockStore != null && this.lockStore.forceUnlock(key);
    }

    public boolean extendLock(Data key, String caller, int threadId, long ttl) {
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    public String getLockOwnerInfo(Data dataKey) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(dataKey) : null;
    }

    public long nextId() {
        return this.idGen.getAndIncrement();
    }

    public MultiMapWrapper getOrCreateMultiMapWrapper(Data dataKey) {
        MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.get(dataKey);
        if (wrapper == null) {
            AbstractCollection coll;
            if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
                coll = new HashSet<MultiMapRecord>(10);
            } else if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
                coll = new LinkedList();
            } else {
                throw new IllegalArgumentException("No Matching CollectionProxyType!");
            }
            wrapper = new MultiMapWrapper(coll);
            this.multiMapWrappers.put(dataKey, wrapper);
        }
        return wrapper;
    }

    public MultiMapWrapper getMultiMapWrapper(Data dataKey) {
        return (MultiMapWrapper)this.multiMapWrappers.get(dataKey);
    }

    public Collection<MultiMapRecord> remove(Data dataKey) {
        MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.remove(dataKey);
        return wrapper != null ? wrapper.getCollection() : null;
    }

    public Set<Data> keySet() {
        Set keySet = this.multiMapWrappers.keySet();
        HashSet<Data> keys = new HashSet<Data>(keySet.size());
        keys.addAll(keySet);
        return keys;
    }

    public Collection<MultiMapRecord> values() {
        LinkedList<MultiMapRecord> valueCollection = new LinkedList<MultiMapRecord>();
        for (MultiMapWrapper wrapper : this.multiMapWrappers.values()) {
            valueCollection.addAll(wrapper.getCollection());
        }
        return valueCollection;
    }

    public boolean containsKey(Data key) {
        return this.multiMapWrappers.containsKey(key);
    }

    public boolean containsEntry(boolean binary, Data key, Data value) {
        MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.get(key);
        if (wrapper == null) {
            return false;
        }
        MultiMapRecord record = new MultiMapRecord(binary ? value : this.nodeEngine.toObject(value));
        return wrapper.getCollection().contains(record);
    }

    public boolean containsValue(boolean binary, Data value) {
        for (Data key : this.multiMapWrappers.keySet()) {
            if (!this.containsEntry(binary, key, value)) continue;
            return true;
        }
        return false;
    }

    public Map<Data, Collection<MultiMapRecord>> copyCollections() {
        HashMap<Data, Collection<MultiMapRecord>> map = new HashMap<Data, Collection<MultiMapRecord>>(this.multiMapWrappers.size());
        for (Map.Entry entry : this.multiMapWrappers.entrySet()) {
            Data key = (Data)entry.getKey();
            Collection<MultiMapRecord> col = this.copyCollection(((MultiMapWrapper)entry.getValue()).getCollection());
            map.put(key, col);
        }
        return map;
    }

    private Collection<MultiMapRecord> copyCollection(Collection<MultiMapRecord> coll) {
        ArrayList<MultiMapRecord> copy = new ArrayList<MultiMapRecord>(coll.size());
        copy.addAll(coll);
        return copy;
    }

    public int size() {
        int size = 0;
        for (MultiMapWrapper wrapper : this.multiMapWrappers.values()) {
            size += wrapper.getCollection().size();
        }
        return size;
    }

    public void clear() {
        Set<Data> locks = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, MultiMapWrapper> temp = new HashMap<Data, MultiMapWrapper>(locks.size());
        for (Data key : locks) {
            MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.get(key);
            if (wrapper == null) continue;
            temp.put(key, wrapper);
        }
        this.multiMapWrappers.clear();
        this.multiMapWrappers.putAll(temp);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public MultiMapConfig getConfig() {
        return this.config;
    }

    public void destroy() {
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.clearLockStore(this.partitionId, this.lockNamespace);
        }
        this.multiMapWrappers.clear();
    }

    public void access() {
        this.lastAccessTime.set(Clock.currentTimeMillis());
    }

    public void update() {
        this.lastUpdateTime.set(Clock.currentTimeMillis());
    }

    public long getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime.get();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLockedCount() {
        return this.lockStore.getLockedKeys().size();
    }
}

