/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.File;
import java.util.Date;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.IncomingFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail.ThumbnailIQ;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;

public class IncomingFileTransferRequestJabberImpl
implements IncomingFileTransferRequest {
    private static final Logger logger = Logger.getLogger(IncomingFileTransferRequestJabberImpl.class);
    private String id;
    private final FileTransferRequest fileTransferRequest;
    private final OperationSetFileTransferJabberImpl fileTransferOpSet;
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private Contact sender;
    private String thumbnailCid;
    private byte[] thumbnail;

    public IncomingFileTransferRequestJabberImpl(ProtocolProviderServiceJabberImpl jabberProvider, OperationSetFileTransferJabberImpl fileTransferOpSet, FileTransferRequest fileTransferRequest) {
        ChatRoomJabberImpl privateContactRoom;
        this.jabberProvider = jabberProvider;
        this.fileTransferOpSet = fileTransferOpSet;
        this.fileTransferRequest = fileTransferRequest;
        String fromUserID = fileTransferRequest.getRequestor();
        OperationSetPersistentPresenceJabberImpl opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
        this.sender = opSetPersPresence.findContactByID(fromUserID);
        if (this.sender == null && (privateContactRoom = ((OperationSetMultiUserChatJabberImpl)jabberProvider.getOperationSet(OperationSetMultiUserChat.class)).getChatRoom(StringUtils.parseBareAddress((String)fromUserID))) != null) {
            this.sender = ((OperationSetPersistentPresenceJabberImpl)jabberProvider.getOperationSet(OperationSetPersistentPresence.class)).createVolatileContact(fromUserID, true);
            privateContactRoom.updatePrivateContactPresenceStatus(this.sender);
        }
        this.id = String.valueOf(System.currentTimeMillis()) + String.valueOf(this.hashCode());
    }

    public Contact getSender() {
        return this.sender;
    }

    public String getFileDescription() {
        return this.fileTransferRequest.getDescription();
    }

    public String getFileName() {
        return this.fileTransferRequest.getFileName();
    }

    public long getFileSize() {
        return this.fileTransferRequest.getFileSize();
    }

    public net.java.sip.communicator.service.protocol.FileTransfer acceptFile(File file) {
        IncomingFileTransferJabberImpl incomingTransfer;
        block2: {
            incomingTransfer = null;
            IncomingFileTransfer jabberTransfer = this.fileTransferRequest.accept();
            try {
                incomingTransfer = new IncomingFileTransferJabberImpl(this.id, this.sender, file, jabberTransfer);
                FileTransferCreatedEvent event = new FileTransferCreatedEvent((net.java.sip.communicator.service.protocol.FileTransfer)incomingTransfer, new Date());
                this.fileTransferOpSet.fireFileTransferCreated(event);
                jabberTransfer.recieveFile(file);
                new OperationSetFileTransferJabberImpl.FileTransferProgressThread((FileTransfer)jabberTransfer, incomingTransfer, this.getFileSize()).start();
            }
            catch (XMPPException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Receiving file failed.", (Throwable)e);
            }
        }
        return incomingTransfer;
    }

    public void rejectFile() {
        this.fileTransferRequest.reject();
        this.fileTransferOpSet.fireFileTransferRequestRejected(new FileTransferRequestEvent((OperationSetFileTransfer)this.fileTransferOpSet, (IncomingFileTransferRequest)this, new Date()));
    }

    public String getID() {
        return this.id;
    }

    public byte[] getThumbnail() {
        return this.thumbnail;
    }

    public void createThumbnailListeners(String cid) {
        this.thumbnailCid = cid;
        if (this.jabberProvider.getConnection() != null) {
            this.jabberProvider.getConnection().addPacketListener((PacketListener)new ThumbnailResponseListener(), (PacketFilter)new AndFilter(new PacketFilter[]{new PacketTypeFilter(IQ.class), new IQTypeFilter(IQ.Type.RESULT)}));
        }
    }

    static /* synthetic */ byte[] access$302(IncomingFileTransferRequestJabberImpl x0, byte[] x1) {
        x0.thumbnail = x1;
        return x1;
    }

    private class ThumbnailResponseListener
    implements PacketListener {
        private ThumbnailResponseListener() {
        }

        public void processPacket(Packet packet) {
            ThumbnailIQ thumbnailResponse;
            if (!(packet instanceof ThumbnailIQ)) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Thumbnail response received.");
            }
            if ((thumbnailResponse = (ThumbnailIQ)packet).getCid() != null && thumbnailResponse.getCid().equals(IncomingFileTransferRequestJabberImpl.this.thumbnailCid)) {
                IncomingFileTransferRequestJabberImpl.access$302(IncomingFileTransferRequestJabberImpl.this, thumbnailResponse.getData());
                FileTransferRequestEvent fileTransferRequestEvent = new FileTransferRequestEvent((OperationSetFileTransfer)IncomingFileTransferRequestJabberImpl.this.fileTransferOpSet, (IncomingFileTransferRequest)IncomingFileTransferRequestJabberImpl.this, new Date());
                IncomingFileTransferRequestJabberImpl.this.fileTransferOpSet.fireFileTransferRequest(fileTransferRequestEvent);
            }
            if (IncomingFileTransferRequestJabberImpl.this.jabberProvider.getConnection() != null) {
                IncomingFileTransferRequestJabberImpl.this.jabberProvider.getConnection().removePacketListener((PacketListener)this);
            }
        }
    }
}

