/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.zrtp;

import gnu.java.zrtp.ZrtpCodes;
import gnu.java.zrtp.utils.ZrtpUtils;
import java.util.EnumSet;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.transform.zrtp.SecurityEventManager;
import org.jitsi.impl.neomedia.transform.zrtp.ZRTPTransformEngine;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpConfigureUtils;
import org.jitsi.service.neomedia.AbstractSrtpControl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.ZrtpControl;

public class ZrtpControlImpl
extends AbstractSrtpControl<ZRTPTransformEngine>
implements ZrtpControl {
    private boolean masterSession = false;
    private AbstractRTPConnector zrtpConnector = null;

    public ZrtpControlImpl() {
        super(SrtpControlType.ZRTP);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.zrtpConnector = null;
    }

    @Override
    public String getCipherString() {
        return ((ZRTPTransformEngine)this.getTransformEngine()).getUserCallback().getCipherString();
    }

    @Override
    public int getCurrentProtocolVersion() {
        ZRTPTransformEngine zrtpEngine = (ZRTPTransformEngine)this.transformEngine;
        return zrtpEngine != null ? zrtpEngine.getCurrentProtocolVersion() : 0;
    }

    @Override
    public String getHelloHash(int index) {
        return ((ZRTPTransformEngine)this.getTransformEngine()).getHelloHash(index);
    }

    @Override
    public String[] getHelloHashSep(int index) {
        return ((ZRTPTransformEngine)this.getTransformEngine()).getHelloHashSep(index);
    }

    @Override
    public int getNumberSupportedVersions() {
        ZRTPTransformEngine zrtpEngine = (ZRTPTransformEngine)this.transformEngine;
        return zrtpEngine != null ? zrtpEngine.getNumberSupportedVersions() : 0;
    }

    @Override
    public String getPeerHelloHash() {
        ZRTPTransformEngine zrtpEngine = (ZRTPTransformEngine)this.transformEngine;
        if (zrtpEngine != null) {
            return zrtpEngine.getPeerHelloHash();
        }
        return new String();
    }

    @Override
    public byte[] getPeerZid() {
        return ((ZRTPTransformEngine)this.getTransformEngine()).getPeerZid();
    }

    @Override
    public String getPeerZidString() {
        byte[] zid = this.getPeerZid();
        String s = new String(ZrtpUtils.bytesToHexString((byte[])zid, (int)zid.length));
        return s;
    }

    @Override
    public boolean getSecureCommunicationStatus() {
        ZRTPTransformEngine zrtpEngine = (ZRTPTransformEngine)this.transformEngine;
        return zrtpEngine != null && zrtpEngine.getSecureCommunicationStatus();
    }

    @Override
    public String getSecurityString() {
        return ((ZRTPTransformEngine)this.getTransformEngine()).getUserCallback().getSecurityString();
    }

    @Override
    public long getTimeoutValue() {
        return 3750L;
    }

    @Override
    protected ZRTPTransformEngine createTransformEngine() {
        ZRTPTransformEngine transformEngine = new ZRTPTransformEngine();
        transformEngine.initialize("GNUZRTP4J.zid", false, ZrtpConfigureUtils.getZrtpConfiguration());
        transformEngine.setUserCallback(new SecurityEventManager(this));
        return transformEngine;
    }

    @Override
    public boolean isSecurityVerified() {
        return ((ZRTPTransformEngine)this.getTransformEngine()).getUserCallback().isSecurityVerified();
    }

    @Override
    public boolean requiresSecureSignalingTransport() {
        return false;
    }

    @Override
    public void setConnector(AbstractRTPConnector connector) {
        this.zrtpConnector = connector;
    }

    @Override
    public void setMasterSession(boolean masterSession) {
        if (masterSession) {
            this.masterSession = masterSession;
        }
    }

    @Override
    public void setMultistream(SrtpControl master) {
        if (master == null || master == this) {
            return;
        }
        if (!(master instanceof ZrtpControlImpl)) {
            throw new IllegalArgumentException("master is no ZRTP control");
        }
        ZRTPTransformEngine engine = (ZRTPTransformEngine)this.getTransformEngine();
        engine.setMultiStrParams(((ZRTPTransformEngine)((ZrtpControlImpl)master).getTransformEngine()).getMultiStrParams());
        engine.setEnableZrtp(true);
    }

    @Override
    public void setSASVerification(boolean verified) {
        ZRTPTransformEngine engine = (ZRTPTransformEngine)this.getTransformEngine();
        if (verified) {
            engine.SASVerified();
        } else {
            engine.resetSASVerified();
        }
    }

    @Override
    public void start(MediaType mediaType) {
        boolean zrtpAutoStart;
        ZRTPTransformEngine engine = (ZRTPTransformEngine)this.getTransformEngine();
        SecurityEventManager securityEventManager = engine.getUserCallback();
        if (this.masterSession) {
            zrtpAutoStart = true;
            securityEventManager.setDHSession(true);
            securityEventManager.setSessionType(mediaType);
        } else {
            zrtpAutoStart = ((ZRTPTransformEngine)this.transformEngine).isEnableZrtp();
            securityEventManager.setSessionType(mediaType);
        }
        engine.setConnector(this.zrtpConnector);
        securityEventManager.setSrtpListener(this.getSrtpListener());
        engine.setEnableZrtp(zrtpAutoStart);
        engine.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZRTPCustomInfoCodes.ZRTPEnabledByDefault));
    }

    public static enum ZRTPCustomInfoCodes {
        ZRTPDisabledByCallEnd,
        ZRTPEnabledByDefault,
        ZRTPEngineInitFailure,
        ZRTPNotEnabledByUser;

    }
}

