/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;

public class GsmParser
extends AbstractDemultiplexer {
    private static double GSM_FRAME_RATE = 50.0;
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("audio.x_gsm")};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private PullDataSource sourceForReadFrame;

    private static InputStream markSupportedInputStream(InputStream is) {
        if (is.markSupported()) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    private static final double nanosToSeconds(double nanos) {
        return nanos / 1.0E9;
    }

    private static final double secondsToNanos(double secs) {
        return secs * 1.0E9;
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public Time setPosition(Time where, int rounding) {
        return null;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    public void start() throws IOException {
        this.source.start();
        PullSourceStream[] streamsForFormat = this.source.getStreams();
        this.tracks = new PullSourceStreamTrack[streamsForFormat.length];
        for (int i = 0; i < streamsForFormat.length; ++i) {
            this.tracks[i] = new PullSourceStreamTrack(streamsForFormat[i]);
        }
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    private class PullSourceStreamTrack
    extends AbstractTrack {
        private javax.sound.sampled.AudioFormat javaSoundInputFormat;
        private PullSourceStream stream;
        private long frameLength;
        private long totalBytesRead;
        private static final int GSM_FRAME_SIZE = 33;

        public PullSourceStreamTrack(PullSourceStream stream) {
            this.stream = stream;
            this.frameLength = stream.getContentLength() / 33L;
        }

        private long bytesToNanos(long bytes) {
            long frames = bytes / 33L;
            double seconds = (double)frames / GSM_FRAME_RATE;
            double nanos = GsmParser.secondsToNanos(seconds);
            return (long)nanos;
        }

        public Time getDuration() {
            long lengthInFrames = this.frameLength;
            if (lengthInFrames < 0L) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (1)");
                return Duration.DURATION_UNKNOWN;
            }
            double lengthInSeconds = (double)lengthInFrames / GSM_FRAME_RATE;
            if (lengthInSeconds < 0.0) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (2)");
                return Duration.DURATION_UNKNOWN;
            }
            double lengthInNanos = GsmParser.secondsToNanos(lengthInSeconds);
            logger.fine("PullSourceStreamTrack: returning " + (long)lengthInNanos);
            return new Time((long)lengthInNanos);
        }

        public Format getFormat() {
            return new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray);
        }

        public long getTotalBytesRead() {
            return this.totalBytesRead;
        }

        private long nanosToBytes(long nanos) {
            double seconds = GsmParser.nanosToSeconds(nanos);
            double frames = seconds * GSM_FRAME_RATE;
            double bytes = frames * 33.0;
            return (long)bytes;
        }

        public void readFrame(Buffer buffer) {
            int BUFFER_SIZE = 16500;
            if (buffer.getData() == null) {
                buffer.setData(new byte[16500]);
            }
            byte[] bytes = (byte[])buffer.getData();
            try {
                int result = this.stream.read(bytes, 0, bytes.length);
                if (result < 0) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                buffer.setLength(result);
                buffer.setOffset(0);
            }
            catch (IOException e) {
                buffer.setEOM(true);
                buffer.setDiscard(true);
                buffer.setLength(0);
                logger.log(Level.WARNING, "" + e, e);
            }
        }

        public void setPssForReadFrame(PullSourceStream pullSourceStream) {
            this.stream = pullSourceStream;
        }

        public long skipNanos(long nanos) throws IOException {
            long bytes = this.nanosToBytes(nanos);
            if (bytes <= 0L) {
                logger.fine("GsmParser: skipping nanos: 0");
                return 0L;
            }
            long bytesSkipped = 0L;
            this.totalBytesRead += 0L;
            if (0L == bytes) {
                logger.fine("GsmParser: skipping nanos: " + nanos);
                return nanos;
            }
            long result = this.bytesToNanos(0L);
            logger.fine("GsmParser: skipping nanos: " + result);
            return result;
        }
    }
}

