/*
 * Decompiled with CFR 0.152.
 */
package com.t4l.jmf;

import com.t4l.jmf.CustomByteArrayOutputStream;
import com.t4l.jmf.RGBConverter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.utility.LoggerSingleton;

public class JPEGEncoder
implements Codec {
    private static final Logger logger = LoggerSingleton.logger;
    private static final VideoFormat jpegFormat = new JPEGFormat();
    private static final RGBFormat rgbFormat = new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1);
    static Hashtable imageTable = new Hashtable();

    protected static int writeJPEG(BufferedImage image, byte[] data) throws IOException {
        ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
        ImageWriteParam iwParam = iw.getDefaultWriteParam();
        float quality = 0.8f;
        iwParam.setCompressionMode(2);
        iwParam.setCompressionQuality(quality);
        CustomByteArrayOutputStream out = new CustomByteArrayOutputStream(data);
        iw.setOutput(out);
        IIOImage img = new IIOImage(image, null, null);
        iw.write(null, img, iwParam);
        return out.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable hashtable = imageTable;
        synchronized (hashtable) {
            imageTable.clear();
        }
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return new String[0];
    }

    public String getName() {
        return "JPEG Encoder";
    }

    public Format[] getSupportedInputFormats() {
        return new VideoFormat[]{rgbFormat};
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return new VideoFormat[]{jpegFormat};
        }
        if (input.relax().matches(rgbFormat)) {
            VideoFormat inputVideoFormat = (VideoFormat)input;
            return new VideoFormat[]{new JPEGFormat(inputVideoFormat.getSize(), -1, Format.byteArray, inputVideoFormat.getFrameRate(), -1, -1)};
        }
        return new Format[0];
    }

    public void open() throws ResourceUnavailableException {
    }

    public int process(Buffer input, Buffer output) {
        Format inputFormat = input.getFormat();
        Format outputFormat = output.getFormat();
        if (inputFormat.relax().matches(rgbFormat) && outputFormat.relax().matches(jpegFormat)) {
            return this.processRGBtoJPEG(input, output);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processRGBtoJPEG(Buffer input, Buffer output) {
        Hashtable hashtable = imageTable;
        synchronized (hashtable) {
            try {
                byte[] bytes;
                RGBFormat inputFormat = (RGBFormat)input.getFormat();
                VideoFormat outputFormat = (VideoFormat)output.getFormat();
                if (outputFormat == null) {
                    int width = inputFormat.getSize().width;
                    int height = inputFormat.getSize().height;
                    outputFormat = new JPEGFormat(new Dimension(width, height), width * height + 200, Format.byteArray, inputFormat.getFrameRate(), -1, -1);
                    output.setFormat(outputFormat);
                }
                int[] data = (int[])input.getData();
                Dimension d = inputFormat.getSize();
                BufferedImage dest = (BufferedImage)imageTable.get(d);
                if (dest == null) {
                    dest = new BufferedImage(d.width, d.height, 1);
                }
                RGBConverter.populateImage(data, input.getOffset(), dest, inputFormat);
                Object obj = output.getData();
                if (obj instanceof byte[]) {
                    bytes = (byte[])obj;
                } else {
                    bytes = new byte[d.width * d.height + 200];
                    output.setData(bytes);
                }
                int length = JPEGEncoder.writeJPEG(dest, bytes);
                imageTable.put(d, dest);
                output.setLength(length);
                output.setDiscard(input.isDiscard());
                output.setDuration(input.getDuration());
                output.setEOM(input.isEOM());
                output.setFlags(input.getFlags());
                output.setHeader(null);
                output.setTimeStamp(input.getTimeStamp());
                output.setSequenceNumber(input.getSequenceNumber());
                output.setOffset(0);
                return 0;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "" + t, t);
                return 1;
            }
        }
    }

    public void reset() {
    }

    public Format setInputFormat(Format f) {
        if (f.relax().matches(rgbFormat)) {
            return f;
        }
        return null;
    }

    public Format setOutputFormat(Format f) {
        if (f.relax().matches(jpegFormat)) {
            return f;
        }
        return null;
    }
}

