/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;

public class PortTracker {
    private static final Logger logger = Logger.getLogger(NetworkUtils.class);
    private int minPort = 1024;
    private int maxPort = 65535;
    private int port = -1;

    public PortTracker(int minPort, int maxPort) {
        this.setRange(minPort, maxPort);
    }

    public int getPort() {
        return this.port;
    }

    public void setRange(int newMinPort, int newMaxPort) throws IllegalArgumentException {
        if (!NetworkUtils.isValidPortNumber(newMinPort) || !NetworkUtils.isValidPortNumber(newMaxPort) || newMaxPort < newMinPort) {
            throw new IllegalArgumentException("[" + newMinPort + " to " + newMaxPort + "] is not a valid port range.");
        }
        this.minPort = newMinPort;
        this.maxPort = newMaxPort;
        if (this.port < this.minPort || this.port > this.maxPort) {
            this.port = this.minPort;
        }
    }

    public void tryRange(String newMinPortString, String newMaxPortString) {
        try {
            int newMinPort = Integer.parseInt(newMinPortString);
            int newMaxPort = Integer.parseInt(newMaxPortString);
            this.setRange(newMinPort, newMaxPort);
        }
        catch (Exception exc) {
            logger.info("Ignoring invalid port range [" + newMinPortString + " to " + newMaxPortString + "]");
            logger.debug("Cause: ", exc);
        }
    }

    public void setNextPort(int nextPort, boolean validate) {
        this.port = (nextPort < this.minPort || nextPort > this.maxPort) && validate ? this.minPort : nextPort;
    }

    public void setNextPort(int nextPort) {
        this.setNextPort(nextPort, true);
    }

    public int getMinPort() {
        return this.minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public static PortTracker createTracker(String newMinPortString, String newMaxPortString) {
        try {
            int minPort = Integer.parseInt(newMinPortString);
            int maxPort = Integer.parseInt(newMaxPortString);
            return new PortTracker(minPort, maxPort);
        }
        catch (Exception exc) {
            logger.info("Ignoring invalid port range [" + newMinPortString + " to " + newMaxPortString + "]");
            logger.debug("Cause: ", exc);
            return null;
        }
    }
}

