/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.versioning;

import com.voxeo.sentinel.client.SentinelClient;
import com.voxeo.versioning.Module;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class Version {
    private String name = "?";
    private String version = "?";
    private String date = "?";
    private static final Logger log = Logger.getLogger(Version.class);

    public static Version get() {
        return LazyHolder.something;
    }

    private Version() {
        this(false);
    }

    private Version(boolean sentinel) {
        try {
            Module module = Version.getModule();
            if (module != null) {
                this.name = module.getName();
                this.version = module.getVersion();
                this.date = module.getDate();
                if (sentinel) {
                    new SentinelClient(module);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error initializing Versioning Framework", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    public static Module getModule() {
        try {
            InputStream inputStream = Version.class.getResourceAsStream("/META-INF/version.xml");
            return Module.parseXML(inputStream);
        }
        catch (Exception e) {
            log.error((Object)"Failed to aquire Version Info!", (Throwable)e);
            return null;
        }
    }

    private static class LazyHolder {
        static final Version something = new Version();

        private LazyHolder() {
        }
    }
}

