/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.AbstractCommand;
import f00f.net.irc.martyr.commands.CtcpMessage;
import f00f.net.irc.martyr.util.FullNick;

public class MessageCommand
extends AbstractCommand {
    private FullNick from;
    private String dest;
    private String message;

    public MessageCommand() {
        this.from = null;
        this.dest = null;
        this.message = null;
    }

    public MessageCommand(String dest, String message) {
        this(null, dest, message);
    }

    public MessageCommand(FullNick dest, String message) {
        this(dest.getNick(), message);
    }

    public MessageCommand(FullNick source, String dest, String message) {
        this.from = source;
        this.dest = dest;
        this.message = message;
    }

    public InCommand parse(String prefix, String identifier, String params) {
        FullNick from = prefix == null || prefix.trim().length() == 0 ? null : new FullNick(prefix);
        String dest = this.getParameter(params, 0);
        String msg = this.getParameter(params, 1);
        if (CtcpMessage.isCtcpString(msg)) {
            return new CtcpMessage(from, dest, msg);
        }
        return new MessageCommand(from, dest, msg);
    }

    public String getIrcIdentifier() {
        return "PRIVMSG";
    }

    public String renderParams() {
        return this.dest + " :" + this.message;
    }

    public FullNick getSource() {
        return this.from;
    }

    public String getDest() {
        return this.dest;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isPrivateToUs(ClientState state) {
        return state.getNick().equals(this.dest);
    }
}

