/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.icbm.AbstractRvIcbm;
import net.kano.joscar.snaccmd.icbm.RecvIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.TlvTools;

public class RecvRvIcbm
extends AbstractRvIcbm
implements RecvIcbm {
    private final FullUserInfo sender;

    protected RecvRvIcbm(SnacPacket packet) {
        super(7, packet);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock channelData = this.getChannelData();
        this.sender = FullUserInfo.readUserInfo(channelData);
        ByteBlock tlvBlock = channelData.subBlock(this.sender.getTotalSize());
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.processRvTlvs(chain);
    }

    public RecvRvIcbm(long icbmMessageId, int status, long rvSessionId, CapabilityBlock cap, LiveWritable rvDataWriter, FullUserInfo sender) {
        super(7, icbmMessageId, status, rvSessionId, cap, rvDataWriter);
        DefensiveTools.checkNull((Object)sender, (String)"sender");
        this.sender = sender;
    }

    public final FullUserInfo getSenderInfo() {
        return this.sender;
    }

    protected final void writeChannelData(OutputStream out) throws IOException {
        this.sender.write(out);
        this.writeRvTlvs(out);
    }

    public String toString() {
        return "RecvRvIcbm: sender=<" + this.sender + ">, on top of " + super.toString();
    }
}

