/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Hop;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.sip.message.Response;

public final class SipProviderImpl
implements SipProvider,
SIPTransactionEventListener {
    protected SipListener sipListener;
    protected SipStackImpl sipStack;
    private HashMap listeningPoints;
    private EventScanner eventScanner;
    private String address;
    private int port;
    private boolean automaticDialogSupportEnabled;
    private String IN_ADDR_ANY = "0.0.0.0";
    private String IN6_ADDR_ANY = "::0";

    protected void stop() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Exiting provider");
        }
        Iterator iterator = this.listeningPoints.values().iterator();
        while (iterator.hasNext()) {
            ListeningPointImpl listeningPointImpl = (ListeningPointImpl)iterator.next();
            listeningPointImpl.removeSipProvider();
        }
        this.eventScanner.stop();
    }

    public ListeningPoint getListeningPoint(String string) {
        if (string == null) {
            throw new NullPointerException("Null transport param");
        }
        return (ListeningPoint)this.listeningPoints.get(string.toUpperCase());
    }

    public void handleEvent(EventObject eventObject, SIPTransaction sIPTransaction) {
        EventWrapper eventWrapper;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("handleEvent " + eventObject + "currentTransaction = " + sIPTransaction + "this.sipListener = " + this.sipListener + "sipEvent.source = " + eventObject.getSource());
            if (eventObject instanceof RequestEvent) {
                eventWrapper = ((RequestEvent)eventObject).getDialog();
                this.sipStack.getLogWriter().logDebug("Dialog = " + eventWrapper);
            } else if (eventObject instanceof ResponseEvent) {
                eventWrapper = ((ResponseEvent)eventObject).getDialog();
                this.sipStack.getLogWriter().logDebug("Dialog = " + eventWrapper);
            }
            this.sipStack.getLogWriter().logStackTrace();
        }
        eventWrapper = new EventWrapper(eventObject, sIPTransaction);
        if (!this.sipStack.reEntrantListener) {
            this.eventScanner.addEvent(eventWrapper);
        } else {
            this.eventScanner.deliverEvent(eventWrapper);
        }
    }

    protected SipProviderImpl(SipStackImpl sipStackImpl) {
        this.eventScanner = sipStackImpl.eventScanner;
        this.sipStack = sipStackImpl;
        this.eventScanner.incrementRefcount();
        this.listeningPoints = new HashMap();
        this.automaticDialogSupportEnabled = this.sipStack.isAutomaticDialogSupportEnabled();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public void addSipListener(SipListener sipListener) throws TooManyListenersException {
        if (this.sipStack.sipListener == null) {
            this.sipStack.sipListener = sipListener;
        } else if (this.sipStack.sipListener != sipListener) {
            throw new TooManyListenersException("Stack already has a listener. Only one listener per stack allowed");
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("add SipListener " + sipListener);
        }
        this.sipListener = sipListener;
    }

    public ListeningPoint getListeningPoint() {
        if (this.listeningPoints.size() > 0) {
            return (ListeningPoint)this.listeningPoints.values().iterator().next();
        }
        return null;
    }

    public CallIdHeader getNewCallId() {
        String string = Utils.generateCallIdentifier(this.getListeningPoint().getIPAddress());
        CallID callID = new CallID();
        try {
            callID.setCallId(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return callID;
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        SIPClientTransaction sIPClientTransaction;
        Object object;
        Object object2;
        if (request == null) {
            throw new NullPointerException("null request");
        }
        if (!this.sipStack.isAlive()) {
            throw new TransactionUnavailableException("Stack is stopped");
        }
        SIPRequest sIPRequest = (SIPRequest)request;
        if (sIPRequest.getTransaction() != null) {
            throw new TransactionUnavailableException("Transaction already assigned to request");
        }
        if (sIPRequest.getTopmostVia() == null) {
            object2 = (ListeningPointImpl)this.getListeningPoint("udp");
            object = ((ListeningPointImpl)object2).getViaHeader();
            request.setHeader((Header)object);
        }
        try {
            sIPRequest.checkHeaders();
        }
        catch (ParseException parseException) {
            throw new TransactionUnavailableException(parseException.getMessage());
        }
        if (sIPRequest.getTopmostVia().getBranch() != null && sIPRequest.getTopmostVia().getBranch().startsWith("z9hG4bK") && this.sipStack.findTransaction((SIPRequest)request, false) != null) {
            throw new TransactionUnavailableException("Transaction already exists!");
        }
        object2 = sIPRequest.getTopmostVia().getTransport();
        object = (ListeningPointImpl)this.getListeningPoint((String)object2);
        if (object == null || !((ListeningPointImpl)object).getSentBy().equalsIgnoreCase(this.IN_ADDR_ANY) && !((ListeningPointImpl)object).getSentBy().equalsIgnoreCase(this.IN6_ADDR_ANY) && !((ListeningPointImpl)object).getSentBy().equalsIgnoreCase(sIPRequest.getTopmostVia().getSentBy().toString())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logError("listeningPoint " + object);
                if (object != null) {
                    this.sipStack.getLogWriter().logError("port = " + ((ListeningPointImpl)object).getPort());
                }
            }
            throw new TransactionUnavailableException("sentBy does not match the sentby setting of the ListeningPoint " + sIPRequest.getTopmostVia().getSentBy().toString());
        }
        if (request.getMethod().equalsIgnoreCase("CANCEL") && (sIPClientTransaction = (SIPClientTransaction)this.sipStack.findCancelTransaction((SIPRequest)request, false)) != null) {
            SIPClientTransaction sIPClientTransaction2 = this.sipStack.createClientTransaction((SIPRequest)request, sIPClientTransaction.getMessageChannel());
            ((SIPTransaction)sIPClientTransaction2).addEventListener(this);
            this.sipStack.addTransaction(sIPClientTransaction2);
            if (sIPClientTransaction.getDialog() != null) {
                sIPClientTransaction2.setDialog((SIPDialog)sIPClientTransaction.getDialog(), sIPRequest.getDialogId(false));
            }
            return sIPClientTransaction2;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("could not find existing transaction for " + ((SIPRequest)request).getFirstLine() + " creating a new one ");
        }
        sIPClientTransaction = null;
        try {
            sIPClientTransaction = this.sipStack.getNextHop((SIPRequest)request);
            if (sIPClientTransaction == null) {
                throw new TransactionUnavailableException("Cannot resolve next hop -- transaction unavailable");
            }
        }
        catch (SipException sipException) {
            throw new TransactionUnavailableException("Cannot resolve next hop -- transaction unavailable", (Throwable)sipException);
        }
        String string = sIPRequest.getDialogId(false);
        SIPDialog sIPDialog = this.sipStack.getDialog(string);
        if (sIPDialog != null && sIPDialog.getState() == DialogState.TERMINATED) {
            this.sipStack.removeDialog(sIPDialog);
        }
        try {
            String string2 = null;
            if (sIPRequest.getTopmostVia().getBranch() == null || !sIPRequest.getTopmostVia().getBranch().startsWith("z9hG4bK")) {
                string2 = Utils.generateBranchId();
                sIPRequest.getTopmostVia().setBranch(string2);
            }
            string2 = sIPRequest.getTopmostVia().getBranch();
            SIPClientTransaction sIPClientTransaction3 = (SIPClientTransaction)this.sipStack.createMessageChannel(sIPRequest, ((ListeningPointImpl)object).getMessageProcessor(), (Hop)sIPClientTransaction);
            sIPClientTransaction3.setNextHop((Hop)sIPClientTransaction);
            if (sIPClientTransaction3 == null) {
                throw new TransactionUnavailableException("Cound not create tx");
            }
            sIPClientTransaction3.setOriginalRequest(sIPRequest);
            sIPClientTransaction3.setBranch(string2);
            if (this.sipStack.isDialogCreated(request.getMethod())) {
                if (sIPDialog != null) {
                    sIPClientTransaction3.setDialog(sIPDialog, sIPRequest.getDialogId(false));
                } else if (this.isAutomaticDialogSupportEnabled()) {
                    SIPDialog sIPDialog2 = this.sipStack.createDialog(sIPClientTransaction3);
                    sIPClientTransaction3.setDialog(sIPDialog2, sIPRequest.getDialogId(false));
                }
            } else if (sIPDialog != null) {
                sIPClientTransaction3.setDialog(sIPDialog, sIPRequest.getDialogId(false));
            }
            sIPClientTransaction3.addEventListener(this);
            return sIPClientTransaction3;
        }
        catch (IOException iOException) {
            throw new TransactionUnavailableException("Could not resolve next hop or listening point unavailable! ", (Throwable)iOException);
        }
        catch (ParseException parseException) {
            InternalErrorHandler.handleException(parseException);
            throw new TransactionUnavailableException("Unexpected Exception FIXME! ", (Throwable)parseException);
        }
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        Object object;
        if (!this.sipStack.isAlive()) {
            throw new TransactionUnavailableException("Stack is stopped");
        }
        SIPServerTransaction sIPServerTransaction = null;
        SIPRequest sIPRequest = (SIPRequest)request;
        try {
            sIPRequest.checkHeaders();
        }
        catch (ParseException parseException) {
            this.sipStack.getLogWriter().logError("Missing a required Header", parseException);
            throw new TransactionUnavailableException(parseException.getMessage());
        }
        if (sIPRequest.getMethod().equals("NOTIFY") && sIPRequest.getFromTag() != null && sIPRequest.getToTag() == null && (object = this.sipStack.findSubscribeTransaction(sIPRequest, (ListeningPointImpl)this.getListeningPoint())) == null) {
            throw new TransactionUnavailableException("Cannot find matching Subscription ");
        }
        if (this.sipStack.isDialogCreated(sIPRequest.getMethod())) {
            if (this.sipStack.findTransaction((SIPRequest)request, true) != null) {
                throw new TransactionAlreadyExistsException("server transaction already exists!");
            }
            sIPServerTransaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (sIPServerTransaction == null) {
                throw new TransactionUnavailableException("Transaction not available");
            }
            if (sIPServerTransaction.getOriginalRequest() == null) {
                sIPServerTransaction.setOriginalRequest(sIPRequest);
            }
            try {
                this.sipStack.addTransaction(sIPServerTransaction);
            }
            catch (IOException iOException) {
                throw new TransactionUnavailableException("Error sending provisional response");
            }
            sIPServerTransaction.addEventListener(this);
            if (this.isAutomaticDialogSupportEnabled()) {
                object = sIPRequest.getDialogId(true);
                SIPDialog sIPDialog = this.sipStack.getDialog((String)object);
                if (sIPDialog == null) {
                    sIPDialog = this.sipStack.createDialog(sIPServerTransaction);
                }
                sIPServerTransaction.setDialog(sIPDialog, sIPRequest.getDialogId(true));
                sIPDialog.addRoute(sIPRequest);
                if (sIPDialog.getRemoteTag() != null && sIPDialog.getLocalTag() != null) {
                    this.sipStack.putDialog(sIPDialog);
                }
            }
        } else if (this.isAutomaticDialogSupportEnabled()) {
            sIPServerTransaction = (SIPServerTransaction)this.sipStack.findTransaction((SIPRequest)request, true);
            if (sIPServerTransaction != null) {
                throw new TransactionAlreadyExistsException("Transaction exists! ");
            }
            sIPServerTransaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (sIPServerTransaction == null) {
                throw new TransactionUnavailableException("Transaction not available!");
            }
            if (sIPServerTransaction.getOriginalRequest() == null) {
                sIPServerTransaction.setOriginalRequest(sIPRequest);
            }
            try {
                this.sipStack.addTransaction(sIPServerTransaction);
            }
            catch (IOException iOException) {
                throw new TransactionUnavailableException("Could not send back provisional response!");
            }
            object = sIPRequest.getDialogId(true);
            SIPDialog sIPDialog = this.sipStack.getDialog((String)object);
            if (sIPDialog != null) {
                sIPDialog.addTransaction(sIPServerTransaction);
                sIPDialog.addRoute(sIPRequest);
                sIPServerTransaction.setDialog(sIPDialog, sIPRequest.getDialogId(true));
            }
        } else {
            sIPServerTransaction = (SIPServerTransaction)this.sipStack.findTransaction((SIPRequest)request, true);
            if (sIPServerTransaction != null) {
                throw new TransactionAlreadyExistsException("Transaction exists! ");
            }
            sIPServerTransaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (sIPServerTransaction != null) {
                if (sIPServerTransaction.getOriginalRequest() == null) {
                    sIPServerTransaction.setOriginalRequest(sIPRequest);
                }
                this.sipStack.mapTransaction(sIPServerTransaction);
                object = sIPRequest.getDialogId(true);
                SIPDialog sIPDialog = this.sipStack.getDialog((String)object);
                if (sIPDialog != null) {
                    sIPDialog.addTransaction(sIPServerTransaction);
                    sIPDialog.addRoute(sIPRequest);
                    sIPServerTransaction.setDialog(sIPDialog, sIPRequest.getDialogId(true));
                }
                return sIPServerTransaction;
            }
            object = (MessageChannel)sIPRequest.getMessageChannel();
            sIPServerTransaction = this.sipStack.createServerTransaction((MessageChannel)object);
            if (sIPServerTransaction == null) {
                throw new TransactionUnavailableException("Transaction unavailable -- too many servrer transactions");
            }
            sIPServerTransaction.setOriginalRequest(sIPRequest);
            this.sipStack.mapTransaction(sIPServerTransaction);
            String string = sIPRequest.getDialogId(true);
            SIPDialog sIPDialog = this.sipStack.getDialog(string);
            if (sIPDialog != null) {
                sIPDialog.addTransaction(sIPServerTransaction);
                sIPDialog.addRoute(sIPRequest);
                sIPServerTransaction.setDialog(sIPDialog, sIPRequest.getDialogId(true));
            }
            return sIPServerTransaction;
        }
        return sIPServerTransaction;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void removeSipListener(SipListener sipListener) {
        if (sipListener == this.sipListener) {
            this.sipListener = null;
        }
        boolean bl = false;
        Iterator iterator = this.sipStack.getSipProviders();
        while (iterator.hasNext()) {
            SipProviderImpl sipProviderImpl = (SipProviderImpl)iterator.next();
            if (sipProviderImpl.sipListener == null) continue;
            bl = true;
        }
        if (!bl) {
            this.sipStack.sipListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(Request request) throws SipException {
        block15: {
            SIPDialog sIPDialog;
            if (!this.sipStack.isAlive()) {
                throw new SipException("Stack is stopped.");
            }
            if (request.getMethod().equals("ACK") && (sIPDialog = this.sipStack.getDialog(((SIPRequest)request).getDialogId(false))) != null && sIPDialog.getState() != null) {
                this.sipStack.getLogWriter().logWarning("Dialog exists -- you may want to use Dialog.sendAck() " + sIPDialog.getState());
            }
            if ((sIPDialog = this.sipStack.getRouter((SIPRequest)request).getNextHop(request)) == null) {
                throw new SipException("could not determine next hop!");
            }
            SIPRequest sIPRequest = (SIPRequest)request;
            if (sIPRequest.getTopmostVia() == null) {
                throw new SipException("Invalid SipRequest -- no via header!");
            }
            try {
                Via via = sIPRequest.getTopmostVia();
                String string = via.getBranch();
                if (string == null || string.length() == 0) {
                    via.setBranch(sIPRequest.getTransactionId());
                }
                MessageChannel messageChannel = null;
                if (this.listeningPoints.containsKey(sIPDialog.getTransport().toUpperCase())) {
                    messageChannel = this.sipStack.createRawMessageChannel(((ListeningPointImpl)this.getListeningPoint((String)sIPDialog.getTransport())).port, (Hop)sIPDialog);
                }
                if (messageChannel != null) {
                    messageChannel.sendMessage(sIPRequest);
                    break block15;
                }
                throw new SipException("Could not create a message channel for " + sIPDialog.toString());
            }
            catch (IOException iOException) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logException(iOException);
                }
                throw new SipException("IO Exception occured while Sending Request", (Throwable)iOException);
            }
            catch (ParseException parseException) {
                InternalErrorHandler.handleException(parseException);
            }
            finally {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("done sending " + request.getMethod() + " to hop " + sIPDialog);
                }
            }
        }
    }

    public void sendResponse(Response response) throws SipException {
        int n;
        if (!this.sipStack.isAlive()) {
            throw new SipException("Stack is stopped");
        }
        SIPResponse sIPResponse = (SIPResponse)response;
        Via via = sIPResponse.getTopmostVia();
        if (via == null) {
            throw new SipException("No via header in response!");
        }
        String string = via.getTransport();
        String string2 = via.getReceived();
        if (string2 == null) {
            string2 = via.getHost();
        }
        if ((n = via.getRPort()) == -1 && (n = via.getPort()) == -1) {
            n = string.equalsIgnoreCase("TLS") ? 5061 : 5060;
        }
        if (string2.indexOf(":") > 0 && string2.indexOf("[") < 0) {
            string2 = "[" + string2 + "]";
        }
        Hop hop = this.sipStack.getAddressResolver().resolveAddress(new HopImpl(string2, n, string));
        try {
            ListeningPointImpl listeningPointImpl = (ListeningPointImpl)this.getListeningPoint(string);
            if (listeningPointImpl == null) {
                throw new SipException("whoopsa daisy! no listening point found for transport " + string);
            }
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(listeningPointImpl.port, hop);
            messageChannel.sendMessage(sIPResponse);
        }
        catch (IOException iOException) {
            throw new SipException(iOException.getMessage());
        }
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        if (listeningPoint == null) {
            throw new NullPointerException("Null listening point");
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        listeningPointImpl.sipProvider = this;
        String string = listeningPointImpl.getTransport().toUpperCase();
        this.address = listeningPoint.getIPAddress();
        this.port = listeningPoint.getPort();
        this.listeningPoints.clear();
        this.listeningPoints.put(string, listeningPoint);
    }

    public Dialog getNewDialog(Transaction transaction) throws SipException {
        if (transaction == null) {
            throw new NullPointerException("Null transaction!");
        }
        if (!this.sipStack.isAlive()) {
            throw new SipException("Stack is stopped.");
        }
        if (this.isAutomaticDialogSupportEnabled()) {
            throw new SipException(" Error - AUTOMATIC_DIALOG_SUPPORT is on");
        }
        if (!this.sipStack.isDialogCreated(transaction.getRequest().getMethod())) {
            throw new SipException("Dialog cannot be created for this method " + transaction.getRequest().getMethod());
        }
        SIPDialog sIPDialog = null;
        SIPTransaction sIPTransaction = (SIPTransaction)transaction;
        if (transaction instanceof ServerTransaction) {
            SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)transaction;
            SIPResponse sIPResponse = sIPServerTransaction.getLastResponse();
            if (sIPResponse != null && sIPResponse.getStatusCode() != 100) {
                throw new SipException("Cannot set dialog after response has been sent");
            }
            SIPRequest sIPRequest = (SIPRequest)transaction.getRequest();
            String string = sIPRequest.getDialogId(true);
            sIPDialog = this.sipStack.getDialog(string);
            if (sIPDialog == null) {
                sIPDialog = this.sipStack.createDialog((SIPTransaction)transaction);
                sIPDialog.addTransaction(sIPTransaction);
                sIPDialog.addRoute(sIPRequest);
                sIPTransaction.setDialog(sIPDialog, null);
            } else {
                sIPTransaction.setDialog(sIPDialog, sIPRequest.getDialogId(true));
            }
        } else {
            SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)transaction;
            SIPResponse sIPResponse = sIPClientTransaction.getLastResponse();
            if (sIPResponse == null) {
                SIPRequest sIPRequest = (SIPRequest)sIPClientTransaction.getRequest();
                String string = sIPRequest.getDialogId(false);
                sIPDialog = this.sipStack.getDialog(string);
                if (sIPDialog != null) {
                    throw new SipException("Dialog already exists!");
                }
                sIPDialog = this.sipStack.createDialog(sIPTransaction);
                sIPClientTransaction.setDialog(sIPDialog, null);
            } else {
                throw new SipException("Cannot call this method after response is received!");
            }
        }
        return sIPDialog;
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent sIPTransactionErrorEvent) {
        SIPTransaction sIPTransaction = (SIPTransaction)sIPTransactionErrorEvent.getSource();
        if (sIPTransactionErrorEvent.getErrorID() == 2) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("TransportError occured on " + sIPTransaction);
            }
            Object object = sIPTransactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent timeoutEvent = null;
            timeoutEvent = object instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)object, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)object, timeout);
            this.handleEvent((EventObject)timeoutEvent, (SIPTransaction)object);
        } else if (sIPTransactionErrorEvent.getErrorID() == 1) {
            Object object = sIPTransactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent timeoutEvent = null;
            timeoutEvent = object instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)object, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)object, timeout);
            this.handleEvent((EventObject)timeoutEvent, (SIPTransaction)object);
        } else if (sIPTransactionErrorEvent.getErrorID() == 3) {
            Object object = sIPTransactionErrorEvent.getSource();
            Transaction transaction = (Transaction)object;
            if (transaction.getDialog() != null) {
                InternalErrorHandler.handleException("Unexpected event !", this.sipStack.getLogWriter());
            }
            Timeout timeout = Timeout.RETRANSMIT;
            TimeoutEvent timeoutEvent = null;
            timeoutEvent = object instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)object, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)object, timeout);
            this.handleEvent((EventObject)timeoutEvent, (SIPTransaction)object);
        }
    }

    public ListeningPoint[] getListeningPoints() {
        ListeningPoint[] listeningPointArray = new ListeningPointImpl[this.listeningPoints.size()];
        this.listeningPoints.values().toArray(listeningPointArray);
        return listeningPointArray;
    }

    public void addListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.sipProvider != null && listeningPointImpl.sipProvider != this) {
            throw new ObjectInUseException("Listening point assigned to another provider");
        }
        String string = listeningPointImpl.getTransport().toUpperCase();
        if (this.listeningPoints.isEmpty()) {
            this.address = listeningPoint.getIPAddress();
            this.port = listeningPoint.getPort();
        } else if (!this.address.equals(listeningPoint.getIPAddress()) || this.port != listeningPoint.getPort()) {
            throw new ObjectInUseException("Provider already has different IP Address associated");
        }
        if (this.listeningPoints.containsKey(string) && this.listeningPoints.get(string) != listeningPoint) {
            throw new ObjectInUseException("Listening point already assigned for transport!");
        }
        listeningPointImpl.sipProvider = this;
        this.listeningPoints.put(string, listeningPointImpl);
    }

    public void removeListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.messageProcessor.inUse()) {
            throw new ObjectInUseException("Object is in use");
        }
        this.listeningPoints.remove(listeningPointImpl.getTransport().toUpperCase());
    }

    public void removeListeningPoints() {
        Iterator iterator = this.listeningPoints.values().iterator();
        while (iterator.hasNext()) {
            ListeningPointImpl listeningPointImpl = (ListeningPointImpl)iterator.next();
            listeningPointImpl.messageProcessor.stop();
            iterator.remove();
        }
    }

    public void setAutomaticDialogSupportEnabled(boolean bl) {
        this.automaticDialogSupportEnabled = bl;
    }

    public boolean isAutomaticDialogSupportEnabled() {
        return this.automaticDialogSupportEnabled;
    }

    public ContactHeader createContactForProvider(String string) {
        try {
            String string2 = this.getListeningPoint(string).getIPAddress();
            int n = this.getListeningPoint(string).getPort();
            SipUri sipUri = new SipUri();
            sipUri.setHost(string2);
            sipUri.setPort(n);
            sipUri.setTransportParam(string);
            Contact contact = new Contact();
            AddressImpl addressImpl = new AddressImpl();
            addressImpl.setURI(sipUri);
            contact.setAddress(addressImpl);
            return contact;
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
            return null;
        }
    }
}

