/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.plugin.rest.entity.UserEntity;
import org.jivesoftware.openfire.plugin.rest.entity.UserProperty;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.xmpp.packet.JID;

public class UserUtils {
    private UserUtils() {
        throw new AssertionError();
    }

    public static List<UserEntity> convertUsersToUserEntities(Collection<User> users, String userSearch) {
        ArrayList<UserEntity> result = new ArrayList<UserEntity>();
        for (User user : users) {
            if (userSearch != null && !user.getUsername().contains(userSearch)) continue;
            result.add(UserUtils.convertUserToUserEntity(user));
        }
        return result;
    }

    public static UserEntity convertUserToUserEntity(User user) {
        UserEntity userEntity = new UserEntity(user.getUsername(), user.getName(), user.getEmail());
        ArrayList<UserProperty> userProperties = new ArrayList<UserProperty>();
        for (Map.Entry property : user.getProperties().entrySet()) {
            userProperties.add(new UserProperty((String)property.getKey(), (String)property.getValue()));
        }
        userEntity.setProperties(userProperties);
        return userEntity;
    }

    public static void checkSubType(int subType) throws UserAlreadyExistsException {
        if (subType < -1 || subType > 3) {
            throw new UserAlreadyExistsException();
        }
    }

    public static JID checkAndGetJID(String jid) {
        if (UserUtils.isValidBareJid(jid)) {
            return new JID(jid);
        }
        if (UserUtils.isValidGroupName(jid)) {
            GroupJID gjid = new GroupJID(jid);
            return gjid.asBareJID();
        }
        return XMPPServer.getInstance().createJID(jid, null);
    }

    public static boolean isValidBareJid(String jid) {
        int index = jid.indexOf(64);
        if (index == -1) {
            return false;
        }
        return jid.indexOf(64, index + 1) == -1;
    }

    public static boolean isValidGroupName(String groupname) {
        try {
            Group group = GroupManager.getInstance().getGroup(groupname);
        }
        catch (GroupNotFoundException e) {
            return false;
        }
        return true;
    }
}

