/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.plugin.rest.controller.UserServiceController;
import org.jivesoftware.openfire.plugin.rest.entity.RosterEntities;
import org.jivesoftware.openfire.plugin.rest.entity.RosterItemEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNotFoundException;

@Path(value="restapi/v1/users/{username}/roster")
public class UserRosterService {
    private static final String COULD_NOT_UPDATE_THE_ROSTER = "Could not update the roster";
    private static final String COULD_NOT_CREATE_ROSTER_ITEM = "Could not create roster item";
    private UserServiceController plugin;

    @PostConstruct
    public void init() {
        this.plugin = UserServiceController.getInstance();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public RosterEntities getUserRoster(@PathParam(value="username") String username) throws ServiceException {
        return this.plugin.getRosterEntities(username);
    }

    @POST
    public Response createRoster(@PathParam(value="username") String username, RosterItemEntity rosterItemEntity) throws ServiceException {
        try {
            this.plugin.addRosterItem(username, rosterItemEntity);
        }
        catch (UserNotFoundException e) {
            throw new ServiceException(COULD_NOT_CREATE_ROSTER_ITEM, "", "UserNotFoundException", Response.Status.NOT_FOUND, e);
        }
        catch (UserAlreadyExistsException e) {
            throw new ServiceException(COULD_NOT_CREATE_ROSTER_ITEM, "", "UserAlreadyExistsException", Response.Status.CONFLICT, e);
        }
        catch (SharedGroupException e) {
            throw new ServiceException(COULD_NOT_CREATE_ROSTER_ITEM, "", "SharedGroupException", Response.Status.BAD_REQUEST, e);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/{rosterJid}")
    public Response deleteRoster(@PathParam(value="username") String username, @PathParam(value="rosterJid") String rosterJid) throws ServiceException {
        try {
            this.plugin.deleteRosterItem(username, rosterJid);
        }
        catch (SharedGroupException e) {
            throw new ServiceException("Could not delete the roster item", rosterJid, "SharedGroupException", Response.Status.BAD_REQUEST, e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="/{rosterJid}")
    public Response updateRoster(@PathParam(value="username") String username, @PathParam(value="rosterJid") String rosterJid, RosterItemEntity rosterItemEntity) throws ServiceException {
        try {
            this.plugin.updateRosterItem(username, rosterJid, rosterItemEntity);
        }
        catch (UserNotFoundException e) {
            throw new ServiceException(COULD_NOT_UPDATE_THE_ROSTER, rosterJid, "UserNotFoundException", Response.Status.NOT_FOUND, e);
        }
        catch (SharedGroupException e) {
            throw new ServiceException(COULD_NOT_UPDATE_THE_ROSTER, rosterJid, "SharedGroupException", Response.Status.BAD_REQUEST, e);
        }
        catch (UserAlreadyExistsException e) {
            throw new ServiceException(COULD_NOT_UPDATE_THE_ROSTER, rosterJid, "UserAlreadyExistsException", Response.Status.CONFLICT, e);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

