/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.jivesoftware.admin.AuthCheckFilter;
import org.jivesoftware.openfire.plugin.rest.exceptions.RESTExceptionMapper;
import org.jivesoftware.openfire.plugin.rest.service.GroupService;
import org.jivesoftware.openfire.plugin.rest.service.MUCRoomAdminsService;
import org.jivesoftware.openfire.plugin.rest.service.MUCRoomMembersService;
import org.jivesoftware.openfire.plugin.rest.service.MUCRoomOutcastsService;
import org.jivesoftware.openfire.plugin.rest.service.MUCRoomOwnersService;
import org.jivesoftware.openfire.plugin.rest.service.MUCRoomService;
import org.jivesoftware.openfire.plugin.rest.service.MessageService;
import org.jivesoftware.openfire.plugin.rest.service.MsgArchiveService;
import org.jivesoftware.openfire.plugin.rest.service.RestAPIService;
import org.jivesoftware.openfire.plugin.rest.service.SecurityAuditLogService;
import org.jivesoftware.openfire.plugin.rest.service.SessionService;
import org.jivesoftware.openfire.plugin.rest.service.StatisticsService;
import org.jivesoftware.openfire.plugin.rest.service.UserGroupService;
import org.jivesoftware.openfire.plugin.rest.service.UserLockoutService;
import org.jivesoftware.openfire.plugin.rest.service.UserRosterService;
import org.jivesoftware.openfire.plugin.rest.service.UserService;
import org.jivesoftware.openfire.plugin.rest.service.UserServiceLegacy;
import org.jivesoftware.util.JiveGlobals;

public class JerseyWrapper
extends ServletContainer {
    private static final String CUSTOM_AUTH_PROPERTY_NAME = "plugin.restapi.customAuthFilter";
    private static final String REST_AUTH_TYPE = "plugin.restapi.httpAuth";
    private static final String AUTHFILTER = "org.jivesoftware.openfire.plugin.rest.AuthFilter";
    private static final String CORSFILTER = "org.jivesoftware.openfire.plugin.rest.CORSFilter";
    private static final String CONTAINER_REQUEST_FILTERS = "com.sun.jersey.spi.container.ContainerRequestFilters";
    private static final String CONTAINER_RESPONSE_FILTERS = "com.sun.jersey.spi.container.ContainerResponseFilters";
    private static final String RESOURCE_CONFIG_CLASS_KEY = "com.sun.jersey.config.property.resourceConfigClass";
    private static final String RESOURCE_CONFIG_CLASS = "com.sun.jersey.api.core.PackagesResourceConfig";
    private static final String SCAN_PACKAGE_DEFAULT = JerseyWrapper.class.getPackage().getName();
    private static final long serialVersionUID = 1L;
    private static final String SERVLET_URL = "restapi/*";
    private static Map<String, Object> config;
    private static PackagesResourceConfig prc;
    private static final Logger JERSEY_LOGGER;
    private static String loadingStatusMessage;

    public static String tryLoadingAuthenticationFilter(String customAuthFilterClassName) {
        try {
            if (customAuthFilterClassName != null) {
                Class.forName(customAuthFilterClassName, false, JerseyWrapper.class.getClassLoader());
                loadingStatusMessage = null;
            }
        }
        catch (ClassNotFoundException e) {
            loadingStatusMessage = "No custom auth filter found for restAPI plugin with name " + customAuthFilterClassName;
        }
        if (customAuthFilterClassName == null || customAuthFilterClassName.isEmpty()) {
            loadingStatusMessage = "Classname field can't be empty!";
        }
        return loadingStatusMessage;
    }

    public static String loadAuthenticationFilter() {
        String customAuthFilterClassName = JiveGlobals.getProperty((String)CUSTOM_AUTH_PROPERTY_NAME);
        String restAuthType = JiveGlobals.getProperty((String)REST_AUTH_TYPE);
        String pickedAuthFilter = AUTHFILTER;
        try {
            if (customAuthFilterClassName != null && "custom".equals(restAuthType)) {
                Class.forName(customAuthFilterClassName, false, JerseyWrapper.class.getClassLoader());
                pickedAuthFilter = customAuthFilterClassName;
                loadingStatusMessage = null;
            }
        }
        catch (ClassNotFoundException e) {
            loadingStatusMessage = "No custom auth filter found for restAPI plugin! " + customAuthFilterClassName + " " + restAuthType;
        }
        prc.getProperties().put(CONTAINER_REQUEST_FILTERS, pickedAuthFilter);
        return loadingStatusMessage;
    }

    public JerseyWrapper() {
        super((Application)prc);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        JerseyWrapper.loadAuthenticationFilter();
        super.init(servletConfig);
        AuthCheckFilter.addExclude((String)SERVLET_URL);
    }

    public void destroy() {
        super.destroy();
        AuthCheckFilter.removeExclude((String)SERVLET_URL);
    }

    public static String getLoadingStatusMessage() {
        return loadingStatusMessage;
    }

    static {
        JERSEY_LOGGER = Logger.getLogger("com.sun.jersey");
        loadingStatusMessage = null;
        JERSEY_LOGGER.setLevel(Level.SEVERE);
        config = new HashMap<String, Object>();
        config.put(RESOURCE_CONFIG_CLASS_KEY, RESOURCE_CONFIG_CLASS);
        config.put("com.sun.jersey.api.json.POJOMappingFeature", true);
        prc = new PackagesResourceConfig(new String[]{SCAN_PACKAGE_DEFAULT});
        prc.setPropertiesAndFeatures(config);
        prc.getProperties().put(CONTAINER_RESPONSE_FILTERS, CORSFILTER);
        JerseyWrapper.loadAuthenticationFilter();
        prc.getClasses().add(RestAPIService.class);
        prc.getClasses().add(MUCRoomService.class);
        prc.getClasses().add(MUCRoomOwnersService.class);
        prc.getClasses().add(MUCRoomAdminsService.class);
        prc.getClasses().add(MUCRoomMembersService.class);
        prc.getClasses().add(MUCRoomOutcastsService.class);
        prc.getClasses().add(UserServiceLegacy.class);
        prc.getClasses().add(UserService.class);
        prc.getClasses().add(UserRosterService.class);
        prc.getClasses().add(UserGroupService.class);
        prc.getClasses().add(UserLockoutService.class);
        prc.getClasses().add(GroupService.class);
        prc.getClasses().add(SessionService.class);
        prc.getClasses().add(MsgArchiveService.class);
        prc.getClasses().add(StatisticsService.class);
        prc.getClasses().add(MessageService.class);
        prc.getClasses().add(SecurityAuditLogService.class);
        prc.getClasses().add(RESTExceptionMapper.class);
    }
}

