/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.request;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.core.Member;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.operation.ScriptExecutorOperation;
import com.hazelcast.internal.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecuteScriptRequest
implements ConsoleRequest {
    private String script;
    private String engine;
    private Set<String> targets;
    private boolean targetAllMembers;
    private Map<String, Object> bindings;

    public ExecuteScriptRequest() {
    }

    public ExecuteScriptRequest(String script, String engine, boolean targetAllMembers, Map<String, Object> bindings) {
        this.script = script;
        this.engine = engine;
        this.targets = new HashSet<String>(0);
        this.targetAllMembers = targetAllMembers;
        this.bindings = bindings;
    }

    public ExecuteScriptRequest(String script, String engine, Set<String> targets, Map<String, Object> bindings) {
        this.script = script;
        this.targets = targets;
        this.engine = engine;
        this.targetAllMembers = false;
        this.bindings = bindings;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) throws Exception {
        ArrayList<Object> results;
        JsonObject jsonResult = new JsonObject();
        if (this.targetAllMembers) {
            Set<Member> members = mcs.getHazelcastInstance().getCluster().getMembers();
            ArrayList<Object> list = new ArrayList<Object>(members.size());
            for (Member member : members) {
                list.add(mcs.callOnMember(member, new ScriptExecutorOperation(this.engine, this.script, this.bindings)));
            }
            results = list;
        } else {
            ArrayList<Object> list = new ArrayList<Object>(this.targets.size());
            for (String string : this.targets) {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(string);
                Address targetAddress = new Address(addressHolder.getAddress(), addressHolder.getPort());
                list.add(mcs.callOnAddress(targetAddress, new ScriptExecutorOperation(this.engine, this.script, this.bindings)));
            }
            results = list;
        }
        StringBuilder sb = new StringBuilder();
        for (String string : results) {
            if (string instanceof String) {
                sb.append((Object)string);
            } else if (string instanceof List) {
                List list = (List)((Object)string);
                for (Object e : list) {
                    sb.append(e).append("\n");
                }
            } else if (string instanceof Map) {
                Map map = (Map)((Object)string);
                for (Object object : map.entrySet()) {
                    Map.Entry entry = (Map.Entry)object;
                    sb.append(entry.getKey()).append("->").append(entry.getValue()).append("\n");
                }
            } else if (string == null) {
                sb.append("error");
            }
            sb.append("\n");
        }
        jsonResult.add("scriptResult", sb.toString());
        root.add("result", jsonResult);
    }

    @Override
    public void fromJson(JsonObject json) {
        this.script = JsonUtil.getString(json, "script", "");
        this.engine = JsonUtil.getString(json, "engine", "");
        this.targets = new HashSet<String>();
        for (JsonValue target : JsonUtil.getArray(json, "targets", new JsonArray())) {
            this.targets.add(target.asString());
        }
        this.targetAllMembers = JsonUtil.getBoolean(json, "targetAllMembers", false);
        this.bindings = new HashMap<String, Object>();
    }
}

