/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.packetlogging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.packetlogging.PacketLoggingActivator;
import net.java.sip.communicator.impl.packetlogging.PacketLoggingConfigurationImpl;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.packetlogging.PacketLoggingConfiguration;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class PacketLoggingServiceImpl
implements PacketLoggingService {
    private static final Logger logger = Logger.getLogger(PacketLoggingServiceImpl.class);
    private FileOutputStream outputStream = null;
    private SaverThread saverThread = new SaverThread();
    private PacketLoggingConfiguration packetLoggingConfiguration = null;
    private static final byte[] fakeEthernetHeader;
    private static final byte[] ipHeaderTemplate;
    private static final byte[] ip6HeaderTemplate;
    private static final byte[] udpHeaderTemplate;
    private static final byte[] tcpHeaderTemplate;
    private Object tcpCounterLock = new Object();
    private long srcCount = 1L;
    private long dstCount = 1L;
    private long written = 0L;
    private File[] files;

    static {
        byte[] byArray = new byte[14];
        byArray[12] = 8;
        fakeEthernetHeader = byArray;
        byte[] byArray2 = new byte[20];
        byArray2[0] = 69;
        byArray2[2] = 3;
        byArray2[3] = 72;
        byArray2[4] = -55;
        byArray2[5] = 20;
        byArray2[8] = 53;
        byArray2[9] = 17;
        byArray2[12] = -43;
        byArray2[13] = -64;
        byArray2[14] = 59;
        byArray2[15] = 75;
        byArray2[16] = -64;
        byArray2[17] = -88;
        byArray2[19] = 52;
        ipHeaderTemplate = byArray2;
        byte[] byArray3 = new byte[40];
        byArray3[0] = 96;
        byArray3[6] = 17;
        byArray3[7] = 64;
        ip6HeaderTemplate = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 19;
        byArray4[1] = -60;
        byArray4[2] = 19;
        byArray4[3] = -60;
        byArray4[4] = 3;
        byArray4[5] = 52;
        udpHeaderTemplate = byArray4;
        byte[] byArray5 = new byte[32];
        byArray5[0] = -73;
        byArray5[1] = 97;
        byArray5[2] = 19;
        byArray5[3] = -60;
        byArray5[4] = 79;
        byArray5[5] = 32;
        byArray5[6] = 55;
        byArray5[7] = 59;
        byArray5[8] = 17;
        byArray5[9] = 29;
        byArray5[10] = -68;
        byArray5[11] = 84;
        byArray5[12] = -128;
        byArray5[13] = 24;
        byArray5[15] = 46;
        byArray5[16] = -84;
        byArray5[17] = 120;
        byArray5[20] = 1;
        byArray5[21] = 1;
        byArray5[22] = 8;
        byArray5[23] = 10;
        byArray5[25] = 6;
        byArray5[26] = -44;
        byArray5[27] = 72;
        byArray5[28] = 110;
        byArray5[29] = -52;
        byArray5[30] = 118;
        byArray5[31] = -67;
        tcpHeaderTemplate = byArray5;
    }

    public void start() {
        this.saverThread.start();
    }

    private void getFileNames() throws Exception {
        int fileCount = this.getConfiguration().getLogfileCount();
        this.files = new File[fileCount];
        int i = 0;
        while (i < fileCount) {
            this.files[i] = PacketLoggingActivator.getFileAccessService().getPrivatePersistentFile(new File("log", "jitsi" + i + ".pcap").toString(), FileCategory.LOG);
            ++i;
        }
    }

    private void rotateFiles() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
        int i = this.getConfiguration().getLogfileCount() - 2;
        while (i >= 0) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (f1.exists()) {
                if (f2.exists()) {
                    f2.delete();
                }
                f1.renameTo(f2);
            }
            --i;
        }
        this.outputStream = new FileOutputStream(this.files[0]);
        this.written = 0L;
        this.createGlobalHeader();
    }

    public void stop() {
        this.saverThread.stopRunning();
        if (this.outputStream != null) {
            try {
                try {
                    this.outputStream.flush();
                    this.outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.outputStream = null;
                }
            }
            finally {
                this.outputStream = null;
            }
        }
    }

    private void createGlobalHeader() throws IOException {
        this.outputStream.write(212);
        this.outputStream.write(195);
        this.outputStream.write(178);
        this.outputStream.write(161);
        this.outputStream.write(2);
        this.outputStream.write(0);
        this.outputStream.write(4);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(255);
        this.outputStream.write(255);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(1);
        this.outputStream.write(0);
        this.outputStream.write(0);
        this.outputStream.write(0);
    }

    public boolean isLoggingEnabled() {
        return this.getConfiguration().isGlobalLoggingEnabled();
    }

    public boolean isLoggingEnabled(PacketLoggingService.ProtocolName protocol) {
        PacketLoggingConfiguration cfg = this.getConfiguration();
        if (cfg.isGlobalLoggingEnabled()) {
            switch (protocol) {
                case SIP: {
                    return cfg.isSipLoggingEnabled();
                }
                case JABBER: {
                    return cfg.isJabberLoggingEnabled();
                }
                case RTP: {
                    return cfg.isRTPLoggingEnabled();
                }
                case ICE4J: {
                    return cfg.isIce4JLoggingEnabled();
                }
            }
            return false;
        }
        return false;
    }

    public void logPacket(PacketLoggingService.ProtocolName protocol, byte[] sourceAddress, int sourcePort, byte[] destinationAddress, int destinationPort, PacketLoggingService.TransportName transport, boolean sender, byte[] packetContent) {
        this.logPacket(protocol, sourceAddress, sourcePort, destinationAddress, destinationPort, transport, sender, packetContent, 0, packetContent.length);
    }

    public void logPacket(PacketLoggingService.ProtocolName protocol, byte[] sourceAddress, int sourcePort, byte[] destinationAddress, int destinationPort, PacketLoggingService.TransportName transport, boolean sender, byte[] packetContent, int packetOffset, int packetLength) {
        this.saverThread.queuePacket(new Packet(protocol, sourceAddress, sourcePort, destinationAddress, destinationPort, transport, sender, packetContent, packetOffset, packetLength));
    }

    public PacketLoggingConfiguration getConfiguration() {
        if (this.packetLoggingConfiguration == null) {
            this.packetLoggingConfiguration = new PacketLoggingConfigurationImpl();
        }
        return this.packetLoggingConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePacket(Packet packet) throws Exception {
        int inclLen;
        short len;
        byte[] transportHeader;
        byte[] ipHeader;
        boolean isIPv4;
        boolean bl = isIPv4 = packet.sourceAddress.length == 4 || packet.destinationAddress.length == 4;
        if (isIPv4) {
            ipHeader = new byte[ipHeaderTemplate.length];
            System.arraycopy(ipHeaderTemplate, 0, ipHeader, 0, ipHeader.length);
            System.arraycopy(packet.sourceAddress, 0, ipHeader, 12, 4);
            System.arraycopy(packet.destinationAddress, 0, ipHeader, 16, 4);
        } else {
            ipHeader = new byte[ip6HeaderTemplate.length];
            System.arraycopy(ip6HeaderTemplate, 0, ipHeader, 0, ipHeader.length);
            System.arraycopy(packet.sourceAddress, 0, ipHeader, 8, 16);
            System.arraycopy(packet.destinationAddress, 0, ipHeader, 24, 16);
        }
        if (packet.transport == PacketLoggingService.TransportName.UDP) {
            byte[] udpHeader = new byte[udpHeaderTemplate.length];
            transportHeader = udpHeader;
            System.arraycopy(udpHeaderTemplate, 0, udpHeader, 0, udpHeader.length);
            PacketLoggingServiceImpl.writeShort(packet.sourcePort, udpHeader, 0);
            PacketLoggingServiceImpl.writeShort(packet.destinationPort, udpHeader, 2);
            len = (short)(packet.packetLength + udpHeader.length);
            PacketLoggingServiceImpl.writeShort(len, udpHeader, 4);
        } else {
            long acknum;
            Object object;
            transportHeader = new byte[tcpHeaderTemplate.length];
            System.arraycopy(tcpHeaderTemplate, 0, transportHeader, 0, transportHeader.length);
            PacketLoggingServiceImpl.writeShort(packet.sourcePort, transportHeader, 0);
            PacketLoggingServiceImpl.writeShort(packet.destinationPort, transportHeader, 2);
            len = (short)(packet.packetLength + transportHeader.length);
            if (packet.sender) {
                long seqnum;
                object = this.tcpCounterLock;
                synchronized (object) {
                    seqnum = this.srcCount;
                    this.srcCount += (long)packet.packetLength;
                    acknum = this.dstCount;
                }
                PacketLoggingServiceImpl.intToBytes((int)(seqnum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 4);
                PacketLoggingServiceImpl.intToBytes((int)(acknum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 8);
            } else {
                long seqnum;
                object = this.tcpCounterLock;
                synchronized (object) {
                    seqnum = this.dstCount;
                    this.dstCount += (long)packet.packetLength;
                    acknum = this.srcCount;
                }
                PacketLoggingServiceImpl.intToBytes((int)(seqnum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 4);
                PacketLoggingServiceImpl.intToBytes((int)(acknum & 0xFFFFFFFFFFFFFFFFL), transportHeader, 8);
            }
        }
        if (isIPv4) {
            short ipTotalLen = (short)(len + ipHeader.length);
            PacketLoggingServiceImpl.writeShort(ipTotalLen, ipHeader, 2);
            ipHeader[9] = packet.transport == PacketLoggingService.TransportName.UDP ? 17 : 6;
            int chk2 = this.computeChecksum(ipHeader);
            ipHeader[10] = (byte)(chk2 >> 8);
            ipHeader[11] = (byte)(chk2 & 0xFF);
        } else {
            PacketLoggingServiceImpl.writeShort(len, ipHeader, 4);
            ipHeader[6] = packet.transport == PacketLoggingService.TransportName.UDP ? 17 : 6;
        }
        long current = System.currentTimeMillis();
        int tsSec = (int)(current / 1000L);
        int tsUsec = (int)(current % 1000L * 1000L);
        int feakHeaderLen = fakeEthernetHeader.length + ipHeader.length + transportHeader.length;
        int origLen = inclLen = packet.packetLength + feakHeaderLen;
        PacketLoggingServiceImpl packetLoggingServiceImpl = this;
        synchronized (packetLoggingServiceImpl) {
            long limit;
            if (this.outputStream == null) {
                this.getFileNames();
                this.rotateFiles();
            }
            if ((limit = this.getConfiguration().getLimit()) > 0L && this.written > limit) {
                this.rotateFiles();
            }
            this.addInt(tsSec);
            this.addInt(tsUsec);
            this.addInt(inclLen);
            this.addInt(origLen);
            this.outputStream.write(fakeEthernetHeader);
            this.outputStream.write(ipHeader);
            this.outputStream.write(transportHeader);
            this.outputStream.write(packet.packetContent, packet.packetOffset, packet.packetLength);
            this.outputStream.flush();
            this.written += (long)(inclLen + 16);
        }
    }

    private void addInt(int d) throws IOException {
        this.outputStream.write(d & 0xFF);
        this.outputStream.write((d & 0xFF00) >> 8);
        this.outputStream.write((d & 0xFF0000) >> 16);
        this.outputStream.write((d & 0xFF000000) >> 24);
    }

    private static final void intToBytes(int address, byte[] data, int offset) {
        data[offset] = (byte)(0xFF & address >>> 24);
        data[offset + 1] = (byte)(0xFF & address >>> 16);
        data[offset + 2] = (byte)(0xFF & address >>> 8);
        data[offset + 3] = (byte)(0xFF & address);
    }

    private static void writeShort(int value, byte[] data, int offset) {
        data[offset] = (byte)(value >> 8);
        data[offset + 1] = (byte)value;
    }

    private int computeChecksum(byte[] data) {
        int total = 0;
        int i = 0;
        int imax = data.length - data.length % 2;
        while (i < imax) {
            total += (data[i++] & 0xFF) << 8 | data[i++] & 0xFF;
        }
        if (i < data.length) {
            total += (data[i] & 0xFF) << 8;
        }
        while ((total & 0xFFFF0000) != 0) {
            total = (total & 0xFFFF) + (total >>> 16);
        }
        total = ~total & 0xFFFF;
        return total;
    }

    private static class Packet {
        PacketLoggingService.ProtocolName protocol;
        byte[] sourceAddress;
        int sourcePort;
        byte[] destinationAddress;
        int destinationPort;
        PacketLoggingService.TransportName transport;
        boolean sender;
        byte[] packetContent;
        int packetOffset;
        int packetLength;

        private Packet(PacketLoggingService.ProtocolName protocol, byte[] sourceAddress, int sourcePort, byte[] destinationAddress, int destinationPort, PacketLoggingService.TransportName transport, boolean sender, byte[] packetContent, int packetOffset, int packetLength) {
            this.protocol = protocol;
            this.sourceAddress = sourceAddress;
            this.sourcePort = sourcePort;
            this.destinationAddress = destinationAddress;
            this.destinationPort = destinationPort;
            this.transport = transport;
            this.sender = sender;
            this.packetContent = packetContent;
            this.packetOffset = packetOffset;
            this.packetLength = packetLength;
        }
    }

    private class SaverThread
    extends Thread {
        private boolean stopped = true;
        private final List<Packet> pktsToSave = new ArrayList<Packet>();

        private SaverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.stopped = false;
            while (!this.stopped) {
                Packet pktToSave;
                SaverThread saverThread = this;
                synchronized (saverThread) {
                    if (this.pktsToSave.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    pktToSave = this.pktsToSave.remove(0);
                }
                if (pktToSave == null) continue;
                try {
                    PacketLoggingServiceImpl.this.savePacket(pktToSave);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.error((Object)"Error writing packet to file", t);
                }
            }
        }

        public synchronized void stopRunning() {
            this.stopped = true;
            this.notifyAll();
        }

        public synchronized void queuePacket(Packet packet) {
            this.pktsToSave.add(packet);
            this.notifyAll();
        }
    }
}

