/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class GraphicUtils {
    public static Shape createRoundedClipShape(int shapeWidth, int shapeHeight, int arcW, int arcH) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, shapeWidth, shapeHeight, arcW, arcH);
    }

    public static BufferedImage createClipImage(Graphics2D g, Shape shape) {
        GraphicsConfiguration gc = g.getDeviceConfiguration();
        BufferedImage img = gc.createCompatibleImage(shape.getBounds().width, shape.getBounds().height, 3);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, shape.getBounds().width, shape.getBounds().height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(shape);
        g2.dispose();
        return img;
    }

    public static void paintBorderGlow(Graphics2D g2, int glowWidth, Shape clipShape, Color glowOuterHigh, Color glowOuterLow) {
        int gw;
        int i = gw = glowWidth * 2;
        while (i >= 2) {
            float pct = (float)(gw - i) / (float)(gw - 1);
            Color mixHi = GraphicUtils.getMixedColor(glowOuterHigh, pct, new Color(255, 255, 255, 200), 1.0f - pct);
            Color mixLo = GraphicUtils.getMixedColor(glowOuterLow, pct, new Color(255, 255, 255, 200), 1.0f - pct);
            g2.setPaint(new GradientPaint(0.0f, (float)clipShape.getBounds().height * 0.25f, mixHi, 0.0f, clipShape.getBounds().height, mixLo));
            g2.setComposite(AlphaComposite.getInstance(10, pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(clipShape);
            i -= 2;
        }
    }

    private static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        int i = 0;
        while (i < clr1.length) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
            ++i;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }
}

