/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import pl.mn.communicator.GGConfiguration;
import pl.mn.communicator.IGGConfiguration;

public abstract class AbstractGGPropertiesConfiguration
implements IGGConfiguration {
    private IGGConfiguration m_defaultGGConfiguration = new GGConfiguration();
    private Properties m_prop = null;
    protected String m_fileName = null;

    public AbstractGGPropertiesConfiguration(String fileName, IGGConfiguration configuration) throws IOException, InvalidPropertiesFormatException {
        this(fileName);
        this.m_defaultGGConfiguration = configuration;
    }

    public AbstractGGPropertiesConfiguration(String fileName) throws IOException, InvalidPropertiesFormatException {
        if (fileName == null) {
            throw new IOException("Unable to find file: " + fileName);
        }
        this.m_fileName = fileName;
        this.m_prop = this.createProperties();
    }

    public int getConnectionThreadSleepTimeInMiliseconds() {
        String connectionThreadSleepTime = String.valueOf(this.m_defaultGGConfiguration.getConnectionThreadSleepTimeInMiliseconds());
        return new Integer(this.m_prop.getProperty("connection.thread.sleep.time", connectionThreadSleepTime));
    }

    public int getPingIntervalInMiliseconds() {
        String pingInterval = String.valueOf(this.m_defaultGGConfiguration.getPingIntervalInMiliseconds());
        return new Integer(this.m_prop.getProperty("ping.interval", pingInterval));
    }

    public int getSocketTimeoutInMiliseconds() {
        String defaultSocketTimeout = String.valueOf(this.m_defaultGGConfiguration.getSocketTimeoutInMiliseconds());
        return new Integer(this.m_prop.getProperty("socket.timeout", defaultSocketTimeout));
    }

    public String getRegistrationURL() {
        String registrationURL = this.m_defaultGGConfiguration.getRegistrationURL();
        return this.m_prop.getProperty("server.registration.url", registrationURL);
    }

    public String getSendPasswordURL() {
        String sendPasswordURL = this.m_defaultGGConfiguration.getSendPasswordURL();
        return this.m_prop.getProperty("send.password.url", sendPasswordURL);
    }

    public String getServerLookupURL() {
        String serverLookupURL = this.m_defaultGGConfiguration.getServerLookupURL();
        return this.m_prop.getProperty("server.lookup.url", serverLookupURL);
    }

    public String getTokenRequestURL() {
        String tokenRequestURL = this.m_defaultGGConfiguration.getServerLookupURL();
        return this.m_prop.getProperty("token.request.url", tokenRequestURL);
    }

    protected abstract Properties createProperties() throws IOException, InvalidPropertiesFormatException;

    protected InputStream getResourceAsStream(final ClassLoader loader, final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }
}

