/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import org.hsqldb.util.ConnectionDialog;

public class ZaurusConnectionDialog
extends ConnectionDialog
implements ActionListener,
ItemListener,
KeyListener {
    static final String[][] sJDBCTypes = new String[][]{{"HSQL In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:."}, {"HSQL Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:test"}, {"MM.MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://localhost/"}, {"JDBC-ODBC Brigde from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:test"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:test"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://localhost:1099/jdbc:cloudscape:test;create=true"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:sample.prp"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://localhost/sample"}};

    ZaurusConnectionDialog(Frame frame, String string) {
        super(frame, string);
        this.addKeyListener(this);
    }

    void create(Insets insets) {
        this.setLayout(new BorderLayout());
        this.addKeyListener(this);
        Panel panel = new Panel(new GridLayout(6, 2, 10, 10));
        panel.addKeyListener(this);
        panel.setBackground(SystemColor.control);
        panel.add(ZaurusConnectionDialog.createLabel("Type:"));
        Choice choice = new Choice();
        choice.addItemListener(this);
        choice.addKeyListener(this);
        for (int i = 0; i < sJDBCTypes.length; ++i) {
            choice.add(sJDBCTypes[i][0]);
        }
        panel.add(choice);
        panel.add(ZaurusConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField("org.hsqldb.jdbcDriver");
        this.mDriver.addKeyListener(this);
        panel.add(this.mDriver);
        panel.add(ZaurusConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField("jdbc:hsqldb:.");
        this.mURL.addKeyListener(this);
        panel.add(this.mURL);
        panel.add(ZaurusConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("sa");
        this.mUser.addKeyListener(this);
        panel.add(this.mUser);
        panel.add(ZaurusConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.addKeyListener(this);
        this.mPassword.setEchoChar('*');
        panel.add(this.mPassword);
        Button button = new Button("Cancel");
        button.setActionCommand("ConnectCancel");
        button.addActionListener(this);
        button.addKeyListener(this);
        panel.add(button);
        button = new Button("Ok");
        button.setActionCommand("ConnectOk");
        button.addActionListener(this);
        button.addKeyListener(this);
        panel.add(button);
        this.setLayout(new BorderLayout());
        this.add("East", ZaurusConnectionDialog.createLabel(" "));
        this.add("West", ZaurusConnectionDialog.createLabel(" "));
        this.mError = new Label("");
        Panel panel2 = ZaurusConnectionDialog.createBorderPanel(this.mError);
        panel2.addKeyListener(this);
        this.add("South", panel2);
        this.add("North", ZaurusConnectionDialog.createLabel(""));
        this.add("Center", panel);
        this.doLayout();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension.width > 640) {
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else if (insets.top > 0 && insets.left > 0) {
            this.setLocation(insets.bottom, insets.right);
            this.setSize(insets.top, insets.left);
        } else {
            this.setLocation(0, 0);
            this.setSize(dimension);
        }
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ConnectOk")) {
            this.finishCreate();
        } else if (string.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.finishCreate();
        } else if (keyEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    protected void finishCreate() {
        try {
            this.mConnection = ZaurusConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mError.setText(exception.toString());
        }
    }

    public static Connection createConnection(Frame frame, String string, Insets insets) {
        ZaurusConnectionDialog zaurusConnectionDialog = new ZaurusConnectionDialog(frame, string);
        zaurusConnectionDialog.create(insets);
        return zaurusConnectionDialog.mConnection;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        for (int i = 0; i < sJDBCTypes.length; ++i) {
            if (!string.equals(sJDBCTypes[i][0])) continue;
            this.mDriver.setText(sJDBCTypes[i][1]);
            this.mURL.setText(sJDBCTypes[i][2]);
        }
    }
}

