/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class RvProxyInitSendCmd
extends RvProxyCmd {
    private static final int TYPE_CAP = 1;
    private final String sn;
    private final long icbmMessageId;
    private final CapabilityBlock capabilityBlock;

    protected RvProxyInitSendCmd(RvProxyPacket rvProxyPacket) {
        super(rvProxyPacket);
        ByteBlock byteBlock = rvProxyPacket.getCommandData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        if (stringBlock != null) {
            this.sn = stringBlock.getString();
            ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
            this.icbmMessageId = BinaryTools.getLong(byteBlock2, 0);
            ByteBlock byteBlock3 = byteBlock2.subBlock(8);
            ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock3);
            Tlv tlv = immutableTlvChain.getFirstTlv(1);
            this.capabilityBlock = tlv != null ? new CapabilityBlock(tlv.getData()) : null;
        } else {
            this.sn = null;
            this.icbmMessageId = 0L;
            this.capabilityBlock = null;
        }
    }

    public RvProxyInitSendCmd(String string, long l) {
        this(string, l, null);
    }

    public RvProxyInitSendCmd(String string, long l, CapabilityBlock capabilityBlock) {
        super(2);
        DefensiveTools.checkNull(string, "sn");
        this.sn = string;
        this.icbmMessageId = l;
        this.capabilityBlock = capabilityBlock;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final long getIcbmMessageId() {
        return this.icbmMessageId;
    }

    public CapabilityBlock getCapabilityBlock() {
        return this.capabilityBlock;
    }

    public void writeCommandData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            OscarTools.writeScreenname(outputStream, this.sn);
            BinaryTools.writeLong(outputStream, this.icbmMessageId);
            if (this.capabilityBlock != null) {
                new Tlv(1, this.capabilityBlock.getBlock()).write(outputStream);
            }
        }
    }

    public String toString() {
        return "RvProxyInitSendCmd: sn=" + this.sn + ", icbmMessageId=" + this.icbmMessageId;
    }
}

