/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.info;

import java.util.List;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.InfoData;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.loc.LocCommand;
import net.kano.joscar.snaccmd.loc.SetInfoCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.CapabilityHandler;
import net.kano.joustsim.oscar.CapabilityListener;
import net.kano.joustsim.oscar.CapabilityManager;
import net.kano.joustsim.oscar.CapabilityManagerListener;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.info.AwayMessageRequestManager;
import net.kano.joustsim.oscar.oscar.service.info.CertificateInfoRequestManager;
import net.kano.joustsim.oscar.oscar.service.info.DirectoryInfoRequestManager;
import net.kano.joustsim.oscar.oscar.service.info.InfoRequestManager;
import net.kano.joustsim.oscar.oscar.service.info.InfoResponseAdapter;
import net.kano.joustsim.oscar.oscar.service.info.InfoResponseListener;
import net.kano.joustsim.oscar.oscar.service.info.InfoServiceListener;
import net.kano.joustsim.oscar.oscar.service.info.UserProfileRequestManager;
import net.kano.joustsim.trust.BuddyCertificateInfo;

public class InfoService
extends Service {
    private static final CertificateInfo CERTINFO_EMPTY = new CertificateInfo(null);
    private CopyOnWriteArrayList<InfoServiceListener> listeners = new CopyOnWriteArrayList();
    private final InfoResponseListener infoRequestListener = new InfoResponseAdapter(){

        public void handleUserProfile(InfoService service, Screenname buddy, String userInfo) {
            assert (InfoService.this == service);
            for (InfoServiceListener listener : InfoService.this.listeners) {
                listener.handleUserProfile(service, buddy, userInfo);
            }
        }

        public void handleAwayMessage(InfoService service, Screenname buddy, String awayMessage) {
            assert (InfoService.this == service);
            for (InfoServiceListener listener : InfoService.this.listeners) {
                listener.handleAwayMessage(service, buddy, awayMessage);
            }
        }

        public void handleCertificateInfo(InfoService service, Screenname buddy, BuddyCertificateInfo certInfo) {
            assert (InfoService.this == service);
            for (InfoServiceListener listener : InfoService.this.listeners) {
                listener.handleCertificateInfo(service, buddy, certInfo);
            }
        }

        public void handleDirectoryInfo(InfoService service, Screenname buddy, DirInfo dirInfo) {
            assert (InfoService.this == service);
            for (InfoServiceListener listener : InfoService.this.listeners) {
                listener.handleDirectoryInfo(service, buddy, dirInfo);
            }
        }
    };
    private final CapabilityManager capabilityManager;
    private CapabilityListener individualCapListener = new CapabilityListener(){

        public void capabilityEnabled(CapabilityHandler handler, boolean enabled) {
            InfoService.this.updateCaps();
        }
    };
    private final CapabilityManagerListener capListener = new CapabilityManagerListener(){

        public void capabilityHandlerAdded(CapabilityManager manager, CapabilityBlock block, CapabilityHandler handler) {
            handler.addCapabilityListener(InfoService.this.individualCapListener);
            InfoService.this.updateCaps();
        }

        public void capabilityHandlerRemoved(CapabilityManager manager, CapabilityBlock block, CapabilityHandler handler) {
            handler.removeCapabilityListener(InfoService.this.individualCapListener);
            InfoService.this.updateCaps();
        }
    };
    private InfoRequestManager profileRequestManager = new UserProfileRequestManager(this);
    private InfoRequestManager awayMsgRequestManager = new AwayMessageRequestManager(this);
    private InfoRequestManager certInfoRequestManager = new CertificateInfoRequestManager(this);
    private InfoRequestManager dirInfoRequestManager = new DirectoryInfoRequestManager(this);
    private String awayMessage = null;
    private String userProfile = null;
    private CertificateInfo certificateInfo = null;

    public InfoService(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection, 2);
        this.capabilityManager = this.getAimConnection().getCapabilityManager();
        this.capabilityManager.addCapabilityListener(this.capListener);
    }

    public SnacFamilyInfo getSnacFamilyInfo() {
        return LocCommand.FAMILY_INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected() {
        InfoData infoData;
        InfoService infoService = this;
        synchronized (infoService) {
            List<CapabilityBlock> caps = this.capabilityManager.getEnabledCapabilities();
            infoData = new InfoData(this.awayMessage, this.userProfile, caps, this.certificateInfo);
        }
        this.sendSnac((SnacCommand)new SetInfoCmd(infoData));
        this.setReady();
    }

    protected void finishUp() {
        this.capabilityManager.removeCapabilityListener(this.capListener);
    }

    public void addInfoListener(InfoServiceListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeInfoListener(InfoServiceListener l) {
        this.listeners.remove((Object)l);
    }

    public synchronized String getCurrentAwayMessage() {
        return this.awayMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAwayMessage(String awayMessage) {
        InfoService infoService = this;
        synchronized (infoService) {
            if (this.awayMessage == awayMessage) {
                return;
            }
            this.awayMessage = awayMessage;
        }
        this.sendSnac((SnacCommand)new SetInfoCmd(new InfoData(null, awayMessage == null ? "" : awayMessage, null, null)));
    }

    public synchronized String getCurrentUserProfile() {
        return this.userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserProfile(String userProfile) {
        DefensiveTools.checkNull((Object)userProfile, (String)"userProfile");
        InfoService infoService = this;
        synchronized (infoService) {
            if (this.userProfile == userProfile) {
                return;
            }
            this.userProfile = userProfile;
        }
        this.sendSnac((SnacCommand)new SetInfoCmd(new InfoData(userProfile == null ? "" : userProfile, null, null, null)));
    }

    public synchronized CertificateInfo getCurrentCertificateInfo() {
        return this.certificateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCertificateInfo(CertificateInfo certificateInfo) {
        InfoService infoService = this;
        synchronized (infoService) {
            if (this.certificateInfo == certificateInfo) {
                return;
            }
            this.certificateInfo = certificateInfo;
        }
        this.sendSnac((SnacCommand)new SetInfoCmd(new InfoData(null, null, null, certificateInfo == null ? CERTINFO_EMPTY : certificateInfo)));
    }

    public void requestUserProfile(Screenname buddy) {
        this.profileRequestManager.request(buddy);
    }

    public void requestUserProfile(Screenname buddy, InfoResponseListener listener) {
        this.profileRequestManager.request(buddy, listener);
    }

    public void requestAwayMessage(Screenname buddy) {
        this.awayMsgRequestManager.request(buddy);
    }

    public void requestAwayMessage(Screenname buddy, InfoResponseListener listener) {
        this.awayMsgRequestManager.request(buddy, listener);
    }

    public void requestCertificateInfo(Screenname buddy) {
        this.certInfoRequestManager.request(buddy);
    }

    public void requestCertificateInfo(Screenname buddy, InfoResponseListener listener) {
        this.certInfoRequestManager.request(buddy, listener);
    }

    public void requestDirectoryInfo(Screenname buddy) {
        this.dirInfoRequestManager.request(buddy);
    }

    public void requestDirectoryInfo(Screenname buddy, InfoResponseListener listener) {
        this.dirInfoRequestManager.request(buddy, listener);
    }

    private void updateCaps() {
        this.sendSnac((SnacCommand)new SetInfoCmd(new InfoData(null, null, this.capabilityManager.getEnabledCapabilities(), null)));
    }

    InfoResponseListener getInfoRequestListener() {
        return this.infoRequestListener;
    }
}

