/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.parsers.StreamParser;
import weblogic.xml.babel.parsers.StreamParserHandler;
import weblogicx.xml.stream.XMLEvent;
import weblogicx.xml.stream.XMLEventStreamBase;

public class BabelXMLEventStream
extends XMLEventStreamBase
implements StreamParserHandler {
    private InputSource inputSource;
    private StreamParser parser;

    public void startDocument(InputSource inputSource) throws SAXException, IOException {
        super.startDocument(inputSource);
        this.inputSource = inputSource;
        this.parser = new StreamParser(inputSource, (StreamParserHandler)this);
        this.running = true;
    }

    public void endDocument(boolean bl) throws SAXException, IOException {
        Reader reader;
        super.endDocument(bl);
        InputStream inputStream = this.inputSource.getByteStream();
        if (inputStream != null) {
            inputStream.close();
        }
        if ((reader = this.inputSource.getCharacterStream()) != null) {
            reader.close();
        }
    }

    protected boolean parseSome() throws SAXException {
        if (!this.parser.hasNext()) {
            return true;
        }
        this.parser.streamParseSome();
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        BabelXMLEventStream babelXMLEventStream = new BabelXMLEventStream();
        babelXMLEventStream.startDocument(SAXElementFactory.createInputSource(stringArray[0]));
        while (babelXMLEventStream.hasNext()) {
            XMLEvent xMLEvent = babelXMLEventStream.next();
            System.out.println(xMLEvent);
        }
    }
}

