/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.examples.interpreter;

import org.xml.sax.SAXException;
import weblogic.xml.babel.examples.interpreter.BooleanExp;
import weblogic.xml.babel.examples.interpreter.Context;
import weblogic.xml.babel.examples.interpreter.ExpressionFactory;
import weblogicx.xml.stream.StartElementEvent;
import weblogicx.xml.stream.XMLEventStream;

class Expression {
    private String name;
    private BooleanExp rootExpression;
    private static final String nodeName = "expression";

    Expression() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public BooleanExp getExpression() {
        return this.rootExpression;
    }

    public void setExpression(BooleanExp booleanExp) {
        this.rootExpression = booleanExp;
    }

    public void read(XMLEventStream xMLEventStream) throws SAXException {
        StartElementEvent startElementEvent = xMLEventStream.getSubStream().startElement();
        if (!startElementEvent.getName().equals("operator")) {
            throw new SAXException("Invalid Expression Syntax");
        }
        this.rootExpression = ExpressionFactory.createExpression(startElementEvent);
        this.rootExpression.read(xMLEventStream);
    }

    public boolean evaluate(Context context) {
        return this.rootExpression.evaluate(context);
    }

    public void replace(String string, BooleanExp booleanExp) {
        this.rootExpression = this.rootExpression.replace(string, booleanExp);
    }

    public String toString() {
        return this.rootExpression.toString();
    }
}

