/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SMTPAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class ThrottlingSmtpAppender
extends SMTPAppender {
    private final long sleepMs = 1000L;
    private long intervalMs = 600000L;
    private long lastSentBufferMs = System.currentTimeMillis();
    private Timer timer = new Timer("ThrottlingSmtpAppender Timer", true);
    private Priority instantTriggerThreshold = null;

    public void activateOptions() {
        super.activateOptions();
        this.setEvaluator(new ThrottlingEvaluator(this.evaluator));
        this.timer.schedule(new TimerTask(){

            public void run() {
                ThrottlingSmtpAppender.this.sendIfElapsed();
            }
        }, 1000L, 1000L);
    }

    private synchronized void sendIfElapsed() {
        if (this.isElapsed() && this.cb.length() > 0) {
            this.sendBuffer();
        }
    }

    protected void sendBuffer() {
        super.sendBuffer();
        this.lastSentBufferMs = System.currentTimeMillis();
    }

    private boolean isElapsed() {
        long now = System.currentTimeMillis();
        return now - this.lastSentBufferMs >= this.intervalMs;
    }

    public long getIntervalMs() {
        return this.intervalMs;
    }

    public void setIntervalMs(long intervalMs) {
        this.intervalMs = intervalMs;
    }

    public Priority getInstantTriggerThreshold() {
        return this.instantTriggerThreshold;
    }

    public void setInstantTriggerThreshold(Priority instantTriggerThreshold) {
        this.instantTriggerThreshold = instantTriggerThreshold;
    }

    private class ThrottlingEvaluator
    implements TriggeringEventEvaluator {
        private final TriggeringEventEvaluator child;

        public ThrottlingEvaluator(TriggeringEventEvaluator child) {
            this.child = child;
        }

        public boolean isTriggeringEvent(LoggingEvent event) {
            if (ThrottlingSmtpAppender.this.instantTriggerThreshold != null && event.getLevel().isGreaterOrEqual(ThrottlingSmtpAppender.this.instantTriggerThreshold)) {
                return true;
            }
            return this.child.isTriggeringEvent(event) && ThrottlingSmtpAppender.this.isElapsed();
        }
    }
}

