/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.voxeo.utils.Dates;
import java.lang.reflect.Type;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeGsonAdapter
implements JsonSerializer<DateTime>,
JsonDeserializer<DateTime> {
    public DateTime deserialize(JsonElement json, Type genericType, JsonDeserializationContext context) throws JsonParseException {
        DateTime result = null;
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            result = Dates.getDateTime(primitive.getAsString(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
        return result;
    }

    public JsonElement serialize(DateTime dateTime, Type sourceType, JsonSerializationContext context) {
        return dateTime != null ? new JsonPrimitive(Dates.format("yyyy-MM-dd'T'HH:mm:ss.SSSZ", (ReadableDateTime)dateTime)) : new JsonNull();
    }
}

