/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.operation.MapLoadAllOperationFactory;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MapLoadGivenKeysRequest
extends AllPartitionsClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private String name;
    private List<Data> keys;
    private boolean replaceExistingValues;

    public MapLoadGivenKeysRequest() {
        this.keys = Collections.emptyList();
    }

    public MapLoadGivenKeysRequest(String name, List<Data> keys, boolean replaceExistingValues) {
        this.name = name;
        this.keys = keys;
        this.replaceExistingValues = replaceExistingValues;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MapLoadAllOperationFactory(this.name, this.keys, this.replaceExistingValues);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 47;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("r", this.replaceExistingValues);
        int size = this.keys.size();
        writer.writeInt("s", size);
        if (size > 0) {
            ObjectDataOutput output = writer.getRawDataOutput();
            for (Data key : this.keys) {
                output.writeData(key);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.replaceExistingValues = reader.readBoolean("r");
        int size = reader.readInt("s");
        if (size < 1) {
            this.keys = Collections.emptyList();
        } else {
            this.keys = new ArrayList<Data>(size);
            ObjectDataInput input = reader.getRawDataInput();
            for (int i = 0; i < size; ++i) {
                Data key = input.readData();
                this.keys.add(key);
            }
        }
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "loadAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.replaceExistingValues};
    }
}

