/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.BasicComponentParameter;
import org.picocontainer.defaults.CollectionComponentParameter;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ComponentParameter
extends BasicComponentParameter {
    public static final ComponentParameter DEFAULT = new ComponentParameter();
    public static final ComponentParameter ARRAY = new ComponentParameter(false);
    public static final ComponentParameter ARRAY_ALLOW_EMPTY = new ComponentParameter(true);
    private final Parameter collectionParameter;

    public ComponentParameter(Object componentKey) {
        this(componentKey, null);
    }

    public ComponentParameter() {
        this(false);
    }

    public ComponentParameter(boolean emptyCollection) {
        this(null, emptyCollection ? CollectionComponentParameter.ARRAY_ALLOW_EMPTY : CollectionComponentParameter.ARRAY);
    }

    public ComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentValueType, emptyCollection));
    }

    public ComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentKeyType, componentValueType, emptyCollection));
    }

    private ComponentParameter(Object componentKey, Parameter collectionParameter) {
        super(componentKey);
        this.collectionParameter = collectionParameter;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        Object result = super.resolveInstance(container, adapter, expectedType);
        if (result == null && this.collectionParameter != null) {
            result = this.collectionParameter.resolveInstance(container, adapter, expectedType);
        }
        return result;
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        if (!super.isResolvable(container, adapter, expectedType)) {
            if (this.collectionParameter != null) {
                return this.collectionParameter.isResolvable(container, adapter, expectedType);
            }
            return false;
        }
        return true;
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        try {
            super.verify(container, adapter, expectedType);
        }
        catch (UnsatisfiableDependenciesException e) {
            if (this.collectionParameter != null) {
                this.collectionParameter.verify(container, adapter, expectedType);
                return;
            }
            throw e;
        }
    }

    public void accept(PicoVisitor visitor) {
        super.accept(visitor);
        if (this.collectionParameter != null) {
            this.collectionParameter.accept(visitor);
        }
    }
}

