/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snac.SnacCmdFactoryList;
import org.jetbrains.annotations.Nullable;

public final class CmdFactoryMgr
extends SnacCmdFactoryList {
    private SnacCmdFactoryList defaultFactories;

    public final synchronized void setDefaultFactoryList(SnacCmdFactoryList list) {
        this.defaultFactories = list;
    }

    public final synchronized SnacCmdFactoryList getDefaultFactoryList() {
        return this.defaultFactories;
    }

    final synchronized SnacCmdFactory findFactory(CmdType type) {
        SnacCmdFactory factory = this.getFactory(type);
        if (factory != null) {
            return factory;
        }
        CmdType familyCmd = new CmdType(type.getFamily());
        factory = this.getFactory(familyCmd);
        if (factory != null) {
            return factory;
        }
        SnacCmdFactoryList defaultFactories = this.defaultFactories;
        if (defaultFactories != null) {
            factory = defaultFactories.getFactory(type);
            if (factory != null) {
                return factory;
            }
            factory = defaultFactories.getFactory(familyCmd);
        }
        if (factory != null) {
            return factory;
        }
        factory = this.getFactory(CmdType.CMDTYPE_ALL);
        if (factory != null) {
            return factory;
        }
        if (defaultFactories != null) {
            factory = defaultFactories.getFactory(CmdType.CMDTYPE_ALL);
        }
        return factory;
    }

    @Nullable
    public SnacCommand generateSnacCommand(SnacPacket packet) {
        CmdType type = new CmdType(packet.getFamily(), packet.getCommand());
        SnacCmdFactory factory = this.findFactory(type);
        if (factory == null) {
            return null;
        }
        return factory.genSnacCommand(packet);
    }

    public String toString() {
        return "CmdFactoryMgr: defaultFactories=" + this.defaultFactories;
    }
}

