/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.awt.Dimension;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.H261Format;
import javax.media.format.H263Format;
import javax.media.format.IndexedColorFormat;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.BonusAudioFormatEncodings;
import net.sf.fmj.media.format.GIFFormat;
import net.sf.fmj.media.format.PNGFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatArgUtils {
    private static final char SEP = ':';
    public static final String BYTE_ARRAY = "B";
    public static final String SHORT_ARRAY = "S";
    public static final String INT_ARRAY = "I";
    public static final String NOT_SPECIFIED = "?";
    public static final String BIG_ENDIAN = "B";
    public static final String LITTLE_ENDIAN = "L";
    public static final String SIGNED = "S";
    public static final String UNSIGNED = "U";
    private static final Map<String, String> formatEncodings = new HashMap<String, String>();
    private static final Map<String, Class<?>> formatClasses = new HashMap();

    private static final void addAudioFormat(String string) {
        FormatArgUtils.addFormat(string, AudioFormat.class);
    }

    private static final void addFormat(String string, Class<?> clazz) {
        formatClasses.put(string.toLowerCase(), clazz);
        formatEncodings.put(string.toLowerCase(), string);
    }

    private static final void addVideoFormat(String string) {
        FormatArgUtils.addFormat(string, VideoFormat.class);
    }

    private static final void buildFormatMap() {
        FormatArgUtils.addAudioFormat("LINEAR");
        FormatArgUtils.addAudioFormat("ULAW");
        FormatArgUtils.addAudioFormat("ULAW/rtp");
        FormatArgUtils.addAudioFormat("alaw");
        FormatArgUtils.addAudioFormat("ima4");
        FormatArgUtils.addAudioFormat("ima4/ms");
        FormatArgUtils.addAudioFormat("msadpcm");
        FormatArgUtils.addAudioFormat("dvi");
        FormatArgUtils.addAudioFormat("dvi/rtp");
        FormatArgUtils.addAudioFormat("g723");
        FormatArgUtils.addAudioFormat("g723/rtp");
        FormatArgUtils.addAudioFormat("g728");
        FormatArgUtils.addAudioFormat("g728/rtp");
        FormatArgUtils.addAudioFormat("g729");
        FormatArgUtils.addAudioFormat("g729/rtp");
        FormatArgUtils.addAudioFormat("g729a");
        FormatArgUtils.addAudioFormat("g729a/rtp");
        FormatArgUtils.addAudioFormat("gsm");
        FormatArgUtils.addAudioFormat("gsm/ms");
        FormatArgUtils.addAudioFormat("gsm/rtp");
        FormatArgUtils.addAudioFormat("MAC3");
        FormatArgUtils.addAudioFormat("MAC6");
        FormatArgUtils.addAudioFormat("truespeech");
        FormatArgUtils.addAudioFormat("msnaudio");
        FormatArgUtils.addAudioFormat("mpeglayer3");
        FormatArgUtils.addAudioFormat("voxwareac8");
        FormatArgUtils.addAudioFormat("voxwareac10");
        FormatArgUtils.addAudioFormat("voxwareac16");
        FormatArgUtils.addAudioFormat("voxwareac20");
        FormatArgUtils.addAudioFormat("voxwaremetavoice");
        FormatArgUtils.addAudioFormat("voxwaremetasound");
        FormatArgUtils.addAudioFormat("voxwarert29h");
        FormatArgUtils.addAudioFormat("voxwarevr12");
        FormatArgUtils.addAudioFormat("voxwarevr18");
        FormatArgUtils.addAudioFormat("voxwaretq40");
        FormatArgUtils.addAudioFormat("voxwaretq60");
        FormatArgUtils.addAudioFormat("msrt24");
        FormatArgUtils.addAudioFormat("mpegaudio");
        FormatArgUtils.addAudioFormat("mpegaudio/rtp");
        FormatArgUtils.addAudioFormat("dolbyac3");
        for (String string : BonusAudioFormatEncodings.ALL) {
            FormatArgUtils.addAudioFormat(string);
        }
        FormatArgUtils.addVideoFormat("cvid");
        FormatArgUtils.addFormat("jpeg", JPEGFormat.class);
        FormatArgUtils.addVideoFormat("jpeg/rtp");
        FormatArgUtils.addVideoFormat("mpeg");
        FormatArgUtils.addVideoFormat("mpeg/rtp");
        FormatArgUtils.addFormat("h261", H261Format.class);
        FormatArgUtils.addVideoFormat("h261/rtp");
        FormatArgUtils.addFormat("h263", H263Format.class);
        FormatArgUtils.addVideoFormat("h263/rtp");
        FormatArgUtils.addVideoFormat("h263-1998/rtp");
        FormatArgUtils.addFormat("rgb", RGBFormat.class);
        FormatArgUtils.addFormat("yuv", YUVFormat.class);
        FormatArgUtils.addFormat("irgb", IndexedColorFormat.class);
        FormatArgUtils.addVideoFormat("smc");
        FormatArgUtils.addVideoFormat("rle");
        FormatArgUtils.addVideoFormat("rpza");
        FormatArgUtils.addVideoFormat("mjpg");
        FormatArgUtils.addVideoFormat("mjpa");
        FormatArgUtils.addVideoFormat("mjpb");
        FormatArgUtils.addVideoFormat("iv32");
        FormatArgUtils.addVideoFormat("iv41");
        FormatArgUtils.addVideoFormat("iv50");
        FormatArgUtils.addFormat("gif", GIFFormat.class);
        FormatArgUtils.addFormat("png", PNGFormat.class);
    }

    private static final String dataTypeToStr(Class<?> clazz) {
        if (clazz == null) {
            return NOT_SPECIFIED;
        }
        if (clazz == Format.byteArray) {
            return "B";
        }
        if (clazz == Format.shortArray) {
            return "S";
        }
        if (clazz == Format.intArray) {
            return INT_ARRAY;
        }
        throw new IllegalArgumentException("" + clazz);
    }

    private static final String dimensionToStr(Dimension dimension) {
        if (dimension == null) {
            return NOT_SPECIFIED;
        }
        return (int)dimension.getWidth() + "x" + (int)dimension.getHeight();
    }

    private static final String endianToStr(int n) {
        if (n == -1) {
            return NOT_SPECIFIED;
        }
        if (n == 1) {
            return "B";
        }
        if (n == 0) {
            return LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unknown endianness: " + n);
    }

    private static final String floatToStr(float f) {
        if (f == -1.0f) {
            return NOT_SPECIFIED;
        }
        return "" + f;
    }

    private static final String intToStr(int n) {
        if (n == -1) {
            return NOT_SPECIFIED;
        }
        return "" + n;
    }

    public static Format parse(String string) throws ParseException {
        String[] stringArray = string.split(":");
        Tokens tokens = new Tokens(stringArray);
        boolean bl = false;
        String string2 = tokens.nextString(null);
        if (string2 == null) {
            throw new ParseException("No encoding specified", 0);
        }
        Class<?> clazz = formatClasses.get(string2.toLowerCase());
        if (clazz == null) {
            throw new ParseException("Unknown encoding: " + string2, -1);
        }
        String string3 = formatEncodings.get(string2.toLowerCase());
        if (string3 == null) {
            throw new ParseException("Unknown encoding: " + string2, -1);
        }
        if (AudioFormat.class.isAssignableFrom(clazz)) {
            double d = tokens.nextDouble();
            int n = tokens.nextInt();
            int n2 = tokens.nextInt();
            int n3 = tokens.nextEndian();
            int n4 = tokens.nextSigned();
            int n5 = tokens.nextInt();
            double d2 = tokens.nextDouble();
            Class<?> clazz2 = tokens.nextDataType();
            if (clazz2 == null) {
                clazz2 = Format.byteArray;
            }
            return new AudioFormat(string3, d, n, n2, n3, n4, n5, d2, clazz2);
        }
        if (VideoFormat.class.isAssignableFrom(clazz)) {
            if (clazz == JPEGFormat.class) {
                Dimension dimension = tokens.nextDimension();
                int n = tokens.nextInt();
                Class<?> clazz3 = tokens.nextDataType();
                if (clazz3 == null) {
                    clazz3 = Format.byteArray;
                }
                float f = tokens.nextFloat();
                return new JPEGFormat(dimension, n, clazz3, f, -1, -1);
            }
            if (clazz == GIFFormat.class) {
                Dimension dimension = tokens.nextDimension();
                int n = tokens.nextInt();
                Class<?> clazz4 = tokens.nextDataType();
                if (clazz4 == null) {
                    clazz4 = Format.byteArray;
                }
                float f = tokens.nextFloat();
                return new GIFFormat(dimension, n, clazz4, f);
            }
            if (clazz == PNGFormat.class) {
                Dimension dimension = tokens.nextDimension();
                int n = tokens.nextInt();
                Class<?> clazz5 = tokens.nextDataType();
                if (clazz5 == null) {
                    clazz5 = Format.byteArray;
                }
                float f = tokens.nextFloat();
                return new PNGFormat(dimension, n, clazz5, f);
            }
            if (clazz == VideoFormat.class) {
                Dimension dimension = tokens.nextDimension();
                int n = tokens.nextInt();
                Class<?> clazz6 = tokens.nextDataType();
                if (clazz6 == null) {
                    clazz6 = Format.byteArray;
                }
                float f = tokens.nextFloat();
                return new VideoFormat(string3, dimension, n, clazz6, f);
            }
            if (clazz == RGBFormat.class) {
                Dimension dimension = tokens.nextDimension();
                int n = tokens.nextInt();
                Class<?> clazz7 = tokens.nextDataType();
                if (clazz7 == null) {
                    clazz7 = Format.byteArray;
                }
                float f = tokens.nextFloat();
                int n6 = tokens.nextInt();
                int n7 = tokens.nextInt();
                int n8 = tokens.nextInt();
                int n9 = tokens.nextInt();
                int n10 = tokens.nextInt();
                int n11 = tokens.nextInt();
                int n12 = tokens.nextInt();
                int n13 = tokens.nextRGBFormatEndian();
                if (n10 == -1 && n11 == -1 && n12 == -1 && n13 == -1) {
                    return new RGBFormat(dimension, n, clazz7, f, n6, n7, n8, n9);
                }
                return new RGBFormat(dimension, n, clazz7, f, n6, n7, n8, n9, n10, n11, n12, n13);
            }
            throw new RuntimeException("TODO: Unknown class: " + clazz);
        }
        throw new RuntimeException("Unknown class: " + clazz);
    }

    private static final String rgbFormatEndianToStr(int n) {
        if (n == -1) {
            return NOT_SPECIFIED;
        }
        if (n == 0) {
            return "B";
        }
        if (n == 1) {
            return LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unknown endianness: " + n);
    }

    private static final String signedToStr(int n) {
        if (n == -1) {
            return NOT_SPECIFIED;
        }
        if (n == 1) {
            return "S";
        }
        if (n == 0) {
            return UNSIGNED;
        }
        throw new IllegalArgumentException("Unknown signedness: " + n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(Format format) {
        Serializable serializable;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(format.getEncoding().toUpperCase());
        if (format instanceof AudioFormat) {
            serializable = (AudioFormat)format;
            arrayList.add(FormatArgUtils.intToStr((int)((AudioFormat)serializable).getSampleRate()));
            arrayList.add(FormatArgUtils.intToStr(((AudioFormat)serializable).getSampleSizeInBits()));
            arrayList.add(FormatArgUtils.intToStr(((AudioFormat)serializable).getChannels()));
            arrayList.add(FormatArgUtils.endianToStr(((AudioFormat)serializable).getEndian()));
            arrayList.add(FormatArgUtils.signedToStr(((AudioFormat)serializable).getSigned()));
            arrayList.add(FormatArgUtils.intToStr(((AudioFormat)serializable).getFrameSizeInBits()));
            arrayList.add(FormatArgUtils.intToStr((int)((AudioFormat)serializable).getFrameRate()));
            if (((Format)serializable).getDataType() != null && ((Format)serializable).getDataType() != Format.byteArray) {
                arrayList.add(FormatArgUtils.dataTypeToStr(((Format)serializable).getDataType()));
            }
        } else {
            VideoFormat videoFormat;
            if (!(format instanceof VideoFormat)) throw new IllegalArgumentException("" + format);
            serializable = (VideoFormat)format;
            if (format.getClass() == JPEGFormat.class) {
                videoFormat = (JPEGFormat)serializable;
                arrayList.add(FormatArgUtils.dimensionToStr(videoFormat.getSize()));
                arrayList.add(FormatArgUtils.intToStr(videoFormat.getMaxDataLength()));
                if (videoFormat.getDataType() != null && videoFormat.getDataType() != Format.byteArray) {
                    arrayList.add(FormatArgUtils.dataTypeToStr(videoFormat.getDataType()));
                }
                arrayList.add(FormatArgUtils.floatToStr(videoFormat.getFrameRate()));
            } else if (format.getClass() == GIFFormat.class) {
                videoFormat = (GIFFormat)serializable;
                arrayList.add(FormatArgUtils.dimensionToStr(videoFormat.getSize()));
                arrayList.add(FormatArgUtils.intToStr(videoFormat.getMaxDataLength()));
                if (videoFormat.getDataType() != null && videoFormat.getDataType() != Format.byteArray) {
                    arrayList.add(FormatArgUtils.dataTypeToStr(videoFormat.getDataType()));
                }
                arrayList.add(FormatArgUtils.floatToStr(videoFormat.getFrameRate()));
            } else if (format.getClass() == PNGFormat.class) {
                videoFormat = (PNGFormat)serializable;
                arrayList.add(FormatArgUtils.dimensionToStr(videoFormat.getSize()));
                arrayList.add(FormatArgUtils.intToStr(videoFormat.getMaxDataLength()));
                if (videoFormat.getDataType() != null && videoFormat.getDataType() != Format.byteArray) {
                    arrayList.add(FormatArgUtils.dataTypeToStr(videoFormat.getDataType()));
                }
                arrayList.add(FormatArgUtils.floatToStr(videoFormat.getFrameRate()));
            } else if (format.getClass() == VideoFormat.class) {
                arrayList.add(FormatArgUtils.dimensionToStr(((VideoFormat)serializable).getSize()));
                arrayList.add(FormatArgUtils.intToStr(((VideoFormat)serializable).getMaxDataLength()));
                if (((Format)serializable).getDataType() != null && ((Format)serializable).getDataType() != Format.byteArray) {
                    arrayList.add(FormatArgUtils.dataTypeToStr(((Format)serializable).getDataType()));
                }
                arrayList.add(FormatArgUtils.floatToStr(((VideoFormat)serializable).getFrameRate()));
            } else {
                if (format.getClass() != RGBFormat.class) throw new IllegalArgumentException("Unknown or unsupported format: " + format);
                videoFormat = (RGBFormat)serializable;
                arrayList.add(FormatArgUtils.dimensionToStr(((VideoFormat)serializable).getSize()));
                arrayList.add(FormatArgUtils.intToStr(((VideoFormat)serializable).getMaxDataLength()));
                if (((Format)serializable).getDataType() != null && ((Format)serializable).getDataType() != Format.byteArray) {
                    arrayList.add(FormatArgUtils.dataTypeToStr(((Format)serializable).getDataType()));
                }
                arrayList.add(FormatArgUtils.floatToStr(((VideoFormat)serializable).getFrameRate()));
                arrayList.add(FormatArgUtils.intToStr(((RGBFormat)videoFormat).getBitsPerPixel()));
                arrayList.add(FormatArgUtils.intToStr(((RGBFormat)videoFormat).getRedMask()));
                arrayList.add(FormatArgUtils.intToStr(((RGBFormat)videoFormat).getGreenMask()));
                arrayList.add(FormatArgUtils.intToStr(((RGBFormat)videoFormat).getBlueMask()));
                arrayList.add(FormatArgUtils.intToStr(((RGBFormat)videoFormat).getPixelStride()));
                arrayList.add(FormatArgUtils.intToStr(((RGBFormat)videoFormat).getLineStride()));
                arrayList.add(FormatArgUtils.intToStr(((RGBFormat)videoFormat).getFlipped()));
                arrayList.add(FormatArgUtils.rgbFormatEndianToStr(((RGBFormat)videoFormat).getEndian()));
            }
        }
        while (arrayList.get(arrayList.size() - 1) == null || ((String)arrayList.get(arrayList.size() - 1)).equals(NOT_SPECIFIED)) {
            arrayList.remove(arrayList.size() - 1);
        }
        serializable = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                ((StringBuilder)serializable).append(':');
            }
            ((StringBuilder)serializable).append((String)arrayList.get(i));
        }
        return ((StringBuilder)serializable).toString();
    }

    static {
        FormatArgUtils.buildFormatMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Tokens {
        private final String[] items;
        private int ix;

        public Tokens(String[] stringArray) {
            this.items = stringArray;
            this.ix = 0;
        }

        public Class<?> nextDataType() throws ParseException {
            String string = this.nextString();
            if (string == null) {
                return null;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return null;
            }
            if ((string = string.toUpperCase()).equals("B")) {
                return Format.byteArray;
            }
            if (string.equals("S")) {
                return Format.shortArray;
            }
            if (string.equals(FormatArgUtils.INT_ARRAY)) {
                return Format.intArray;
            }
            throw new ParseException("Expected one of [B,S,I]: " + string, -1);
        }

        public Dimension nextDimension() throws ParseException {
            int n;
            int n2;
            String string = this.nextString();
            if (string == null) {
                return null;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return null;
            }
            String[] stringArray = (string = string.toUpperCase()).split("X");
            if (stringArray.length != 2) {
                throw new ParseException("Expected WIDTHxHEIGHT: " + string, -1);
            }
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Expected integer: " + stringArray[0], -1);
            }
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Expected integer: " + stringArray[1], -1);
            }
            return new Dimension(n2, n);
        }

        public double nextDouble() throws ParseException {
            String string = this.nextString();
            if (string == null) {
                return -1.0;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1.0;
            }
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Expected double: " + string, -1);
            }
        }

        public int nextEndian() throws ParseException {
            String string = this.nextString();
            if (string == null) {
                return -1;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            if ((string = string.toUpperCase()).equals("B")) {
                return 1;
            }
            if (string.equals(FormatArgUtils.LITTLE_ENDIAN)) {
                return 0;
            }
            throw new ParseException("Expected one of [B,L]: " + string, -1);
        }

        public float nextFloat() throws ParseException {
            String string = this.nextString();
            if (string == null) {
                return -1.0f;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1.0f;
            }
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Expected float: " + string, -1);
            }
        }

        public int nextInt() throws ParseException {
            String string = this.nextString();
            if (string == null) {
                return -1;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Expected integer: " + string, -1);
            }
        }

        public int nextRGBFormatEndian() throws ParseException {
            String string = this.nextString();
            if (string == null) {
                return -1;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            if ((string = string.toUpperCase()).equals("B")) {
                return 0;
            }
            if (string.equals(FormatArgUtils.LITTLE_ENDIAN)) {
                return 1;
            }
            throw new ParseException("Expected one of [B,L]: " + string, -1);
        }

        public int nextSigned() throws ParseException {
            String string = this.nextString();
            if (string == null) {
                return -1;
            }
            if (string.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            if ((string = string.toUpperCase()).equals(FormatArgUtils.UNSIGNED)) {
                return 0;
            }
            if (string.equals("S")) {
                return 1;
            }
            throw new ParseException("Expected one of [U,U]: " + string, -1);
        }

        public String nextString() {
            return this.nextString(null);
        }

        public String nextString(String string) {
            if (this.ix >= this.items.length) {
                return string;
            }
            String string2 = this.items[this.ix];
            ++this.ix;
            return string2;
        }
    }
}

