/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.Buffer;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.utility.ByteBufferOutputStream;

public class RTPPacket
extends Packet {
    public Packet base;
    public boolean extensionPresent;
    public int marker;
    public int payloadType;
    public int seqnum;
    public long timestamp;
    public int ssrc;
    public int[] csrc;
    public int extensionType;
    public byte[] extension;
    public int payloadoffset;
    public int payloadlength;
    public Buffer.RTPHeaderExtension headerExtension;

    public RTPPacket() {
    }

    public RTPPacket(Packet packet) {
        super(packet);
        this.base = packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble(int n, boolean bl) {
        this.length = n;
        this.offset = 0;
        byte[] byArray = new byte[n];
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(byArray, 0, n);
        DataOutputStream dataOutputStream = new DataOutputStream(byteBufferOutputStream);
        try {
            int n2;
            int n3 = -128;
            if (this.headerExtension != null) {
                n3 = (byte)(n3 | 0x10);
            }
            dataOutputStream.writeByte(n3);
            int n4 = this.payloadType;
            if (this.marker == 1) {
                n4 = this.payloadType | 0x80;
            }
            dataOutputStream.writeByte((byte)n4);
            dataOutputStream.writeShort(this.seqnum);
            dataOutputStream.writeInt((int)this.timestamp);
            dataOutputStream.writeInt(this.ssrc);
            if (this.headerExtension != null && (n2 = (this.headerExtension.value.length + 3) / 4) > 0) {
                int n5;
                dataOutputStream.writeShort(48862);
                dataOutputStream.writeShort(n2);
                dataOutputStream.writeByte(this.headerExtension.id << 4 | this.headerExtension.value.length - 1);
                dataOutputStream.write(this.headerExtension.value, 0, this.headerExtension.value.length);
                if (n5 != 0) {
                    for (n5 = (this.headerExtension.value.length + 1) % 4; n5 < 4; ++n5) {
                        dataOutputStream.writeByte(0);
                    }
                }
            }
            dataOutputStream.write(this.base.data, this.payloadoffset, this.payloadlength);
            this.data = byArray;
        }
        catch (IOException iOException) {
            System.out.println("caught IOException in DOS");
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int calcLength() {
        int n = 0;
        if (this.headerExtension != null) {
            int n2 = (this.headerExtension.value.length + 3) / 4;
            n = (n2 + 1) * 4;
        }
        return 12 + n + this.payloadlength;
    }

    public RTPPacket clone() {
        RTPPacket rTPPacket = new RTPPacket(this.base.clone());
        rTPPacket.extensionPresent = this.extensionPresent;
        rTPPacket.marker = this.marker;
        rTPPacket.payloadType = this.payloadType;
        rTPPacket.seqnum = this.seqnum;
        rTPPacket.timestamp = this.timestamp;
        rTPPacket.ssrc = this.ssrc;
        rTPPacket.csrc = (int[])this.csrc.clone();
        rTPPacket.extensionType = this.extensionType;
        rTPPacket.extension = this.extension;
        rTPPacket.payloadoffset = this.payloadoffset;
        rTPPacket.payloadlength = this.payloadlength;
        rTPPacket.headerExtension = this.headerExtension;
        return rTPPacket;
    }

    public String toString() {
        String string = "RTP Packet:\n\tPayload Type: " + this.payloadType + "    Marker: " + this.marker + "\n\tSequence Number: " + this.seqnum + "\n\tTimestamp: " + this.timestamp + "\n\tSSRC (Sync Source): " + this.ssrc + "\n\tPayload Length: " + this.payloadlength + "    Payload Offset: " + this.payloadoffset + "\n";
        if (this.csrc.length > 0) {
            string = string + "Contributing sources:  " + this.csrc[0];
            for (int i = 1; i < this.csrc.length; ++i) {
                string = string + ", " + this.csrc[i];
            }
            string = string + "\n";
        }
        if (this.extensionPresent) {
            string = string + "\tExtension:  type " + this.extensionType + ", length " + this.extension.length + "\n";
        }
        return string;
    }
}

