/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class PacketForwarder
implements Runnable {
    PacketSource source = null;
    PacketConsumer consumer = null;
    RTPMediaThread thread;
    boolean closed = false;
    private boolean paused;
    public IOException exception = null;

    public PacketForwarder(PacketSource packetSource, PacketConsumer packetConsumer) {
        this.source = packetSource;
        this.consumer = packetConsumer;
        this.closed = false;
        this.exception = null;
    }

    private boolean checkForClose() {
        if (this.closed && this.thread != null) {
            if (this.source != null) {
                this.source.closeSource();
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.closed = true;
        if (this.consumer != null) {
            this.consumer.closeConsumer();
        }
    }

    public PacketConsumer getConsumer() {
        return this.consumer;
    }

    public String getId() {
        if (this.thread == null) {
            System.err.println("the packetforwarders thread is null");
            return null;
        }
        return this.thread.getName();
    }

    public PacketSource getSource() {
        return this.source;
    }

    public void run() {
        if (this.closed || this.exception != null) {
            if (this.source != null) {
                this.source.closeSource();
            }
            return;
        }
        try {
            do {
                Packet packet = this.source.receiveFrom();
                if (this.checkForClose()) {
                    return;
                }
                try {
                    if (packet == null) continue;
                    this.consumer.sendTo(packet);
                }
                catch (InterruptedIOException interruptedIOException) {
                    // empty catch block
                }
            } while (!this.checkForClose());
        }
        catch (IOException iOException) {
            if (!this.checkForClose()) {
                this.exception = iOException;
            }
        }
        finally {
            this.consumer.closeConsumer();
        }
    }

    public void setVideoPriority() {
        this.thread.useVideoNetworkPriority();
    }

    public void startPF() {
        this.startPF(null);
    }

    public void startPF(String string) {
        if (this.thread != null) {
            throw new IllegalArgumentException("Called start more than once");
        }
        if (string == null) {
            string = "RTPMediaThread";
        }
        this.thread = new RTPMediaThread(this, string);
        this.thread.useNetworkPriority();
        this.thread.setDaemon(true);
        this.thread.start();
    }
}

