/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import com.sun.media.util.Registry;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.BasicJitterBufferBehaviour;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPSourceStream;

class AudioJitterBufferBehaviour
extends BasicJitterBufferBehaviour {
    private static final int DEFAULT_AUD_PKT_SIZE = 256;
    private static final int DEFAULT_MS_PER_PKT = 20;
    private static final int INITIAL_PACKETS = 300;
    private static final AudioFormat MPEG = new AudioFormat("mpegaudio/rtp");
    private final boolean AJB_ENABLED = Registry.getBoolean("adaptive_jitter_buffer_ENABLE", true);
    private final int AJB_GROW_INCREMENT = Registry.getInt("adaptive_jitter_buffer_GROW_INCREMENT", 2);
    private final int AJB_GROW_INTERVAL = Registry.getInt("adaptive_jitter_buffer_GROW_INTERVAL", 30);
    private final int AJB_GROW_THRESHOLD = Registry.getInt("adaptive_jitter_buffer_GROW_THRESHOLD", 3);
    private final int AJB_MAX_SIZE = Registry.getInt("adaptive_jitter_buffer_MAX_SIZE", 16);
    private final int AJB_MIN_SIZE = Registry.getInt("adaptive_jitter_buffer_MIN_SIZE", 4);
    private final int AJB_SHRINK_DECREMENT = Registry.getInt("adaptive_jitter_buffer_SHRINK_DECREMENT", 1);
    private final int AJB_SHRINK_INTERVAL = Registry.getInt("adaptive_jitter_buffer_SHRINK_INTERVAL", 120);
    private final int AJB_SHRINK_THRESHOLD = Registry.getInt("adaptive_jitter_buffer_SHRINK_THRESHOLD", 1);
    private int growCount;
    private byte[] history;
    private int historyLength;
    private int historyTail;
    private long msPerPkt = 20L;
    private boolean replenish = true;
    private int shrinkCount = 0;
    private boolean skipFec = false;

    public AudioJitterBufferBehaviour(RTPSourceStream rTPSourceStream) {
        super(rTPSourceStream);
        this.initHistory();
    }

    public void dropPkt() {
        super.dropPkt();
        this.skipFec = true;
        if (this.q.getFillCount() < this.AJB_SHRINK_THRESHOLD) {
            this.shrinkCount = 0;
        }
    }

    public int getAbsoluteMaximumDelay() {
        long l;
        if (this.isAdaptive()) {
            long l2 = this.msPerPkt;
            if (l2 <= 0L) {
                l2 = 20L;
            }
            l = (long)this.AJB_MAX_SIZE * l2;
        } else {
            l = super.getAbsoluteMaximumDelay();
        }
        return l > 65535L ? 65535 : (int)l;
    }

    public int getMaximumDelay() {
        long l;
        long l2 = this.msPerPkt;
        if (l2 <= 0L) {
            l2 = 20L;
        }
        return (l = (long)this.q.getCapacity() * l2) > 65535L ? 65535 : (int)l;
    }

    public int getNominalDelay() {
        long l;
        long l2 = this.msPerPkt;
        if (l2 <= 0L) {
            l2 = 20L;
        }
        return (l = (long)(this.q.getCapacity() / 2) * l2) > 65535L ? 65535 : (int)l;
    }

    protected void grow(int n) {
        super.grow(n);
        this.resetHistory();
    }

    private void initHistory() {
        this.history = new byte[this.AJB_GROW_INTERVAL];
        this.historyLength = 0;
        this.historyTail = 0;
        this.growCount = 0;
    }

    public boolean isAdaptive() {
        return this.AJB_ENABLED;
    }

    protected int monitorQSize(Buffer buffer) {
        long l;
        int n;
        BufferControl bufferControl;
        block13: {
            super.monitorQSize(buffer);
            if (this.AJB_ENABLED) {
                int n2;
                int n3 = this.q.getCapacity();
                if (this.historyLength >= this.AJB_GROW_INTERVAL && this.growCount >= this.AJB_GROW_THRESHOLD && n3 < this.AJB_MAX_SIZE && (n2 = Math.min(n3 + this.AJB_GROW_INCREMENT, this.AJB_MAX_SIZE)) > n3) {
                    this.grow(n2);
                }
                ++this.shrinkCount;
                if (this.shrinkCount >= this.AJB_SHRINK_INTERVAL && n3 > this.AJB_MIN_SIZE && this.q.freeNotEmpty() && (n2 = Math.max(n3 - this.AJB_SHRINK_DECREMENT, this.AJB_MIN_SIZE)) < n3) {
                    this.shrink(n2);
                }
            }
            if ((bufferControl = this.getBufferControl()) == null) {
                return 0;
            }
            Format format = this.stream.getFormat();
            n = this.stats.getSizePerPacket();
            if (n <= 0) {
                n = 256;
            }
            if (MPEG.matches(format)) {
                l = n / 4;
            } else {
                l = 20L;
                try {
                    long l2 = buffer.getDuration();
                    if (l2 <= 0L) {
                        l2 = ((AudioFormat)format).computeDuration(buffer.getLength());
                        if (l2 > 0L) {
                            l = l2 / 1000000L;
                        }
                    } else {
                        l = l2 / 1000000L;
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block13;
                    throw (ThreadDeath)throwable;
                }
            }
        }
        this.msPerPkt = (this.msPerPkt + l) / 2L;
        l = this.msPerPkt == 0L ? 20L : this.msPerPkt;
        int n4 = (int)(bufferControl.getBufferLength() / l);
        if (!this.AJB_ENABLED && n4 > this.q.getCapacity()) {
            this.grow(n4);
            int n5 = this.q.getCapacity();
            Log.comment("Grew audio RTP packet queue to: " + n5 + " pkts, " + n5 * n + " bytes.\n");
        }
        return n4;
    }

    public boolean preAdd(Buffer buffer, RTPRawReceiver rTPRawReceiver) {
        long l;
        long l2 = this.stream.getLastReadSequenceNumber();
        if (l2 != 0x7FFFFFFFFFFFFFFEL && (l = buffer.getSequenceNumber()) < l2) {
            if (l2 - l < (long)this.AJB_MAX_SIZE) {
                this.recordInHistory(true);
                this.stats.incrementDiscardedLate();
            } else {
                this.stats.incrementDiscardedVeryLate();
            }
            return false;
        }
        this.recordInHistory(false);
        if (!super.preAdd(buffer, rTPRawReceiver)) {
            return false;
        }
        if (this.AJB_ENABLED && this.q.noMoreFree() && this.stats.getNbAdd() > 300) {
            int n = this.q.getCapacity();
            if (n < this.AJB_MAX_SIZE) {
                this.grow(Math.min(n * 2, this.AJB_MAX_SIZE));
            } else {
                while (this.q.getFillCount() >= n / 2) {
                    this.stats.incrementDiscardedFull();
                    this.dropPkt();
                }
            }
        }
        return true;
    }

    public void read(Buffer buffer) {
        int n;
        super.read(buffer);
        if (!buffer.isDiscard() && this.skipFec) {
            buffer.setFlags(buffer.getFlags() | 0x10000);
            this.skipFec = false;
        }
        if ((n = this.q.getFillCount()) == 0) {
            this.replenish = true;
        }
        if (n < this.AJB_SHRINK_THRESHOLD) {
            this.shrinkCount = 0;
        }
    }

    private void recordInHistory(boolean bl) {
        byte by = bl ? (byte)1 : 0;
        this.growCount += by - this.history[this.historyTail];
        this.history[this.historyTail] = by;
        this.historyTail = (this.historyTail + 1) % this.AJB_GROW_INTERVAL;
        if (this.historyLength < this.AJB_GROW_INTERVAL) {
            ++this.historyLength;
        }
    }

    public void reset() {
        super.reset();
        this.resetHistory();
    }

    private void resetHistory() {
        this.historyLength = 0;
        this.shrinkCount = 0;
    }

    private void shrink(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("capacity");
        }
        int n2 = this.q.getCapacity();
        if (n == n2) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("capacity");
        }
        Log.info("Shrinking packet queue to " + n);
        int n3 = 0;
        while (this.q.getFillCount() > n) {
            this.dropPkt();
            this.stats.incrementDiscardedShrink();
            ++n3;
        }
        this.q.setCapacity(n);
        while (n3 < this.AJB_SHRINK_DECREMENT && this.q.fillNotEmpty()) {
            this.dropPkt();
            this.stats.incrementDiscardedShrink();
            ++n3;
        }
        this.resetHistory();
    }

    public boolean willReadBlock() {
        boolean bl = super.willReadBlock();
        if (!bl) {
            if (this.replenish && this.q.getFillCount() >= this.q.getCapacity() / 2) {
                this.replenish = false;
            }
            bl = this.replenish;
        }
        return bl;
    }
}

